
/**********************************************************************************************
	JS functions for tree application

	Copyright (c) 2011 MCQ TECH GmbH (rstiawa@metz-connect.com)
	Version 0.1		09.2011

***********************************************************************************************/


/*
	Anmerkungen:



	// Ausloesen eines erneuten Ladens des Tree aus dem frame_content heraus:
	top.getDataExtended ("tree", "tree_data", "top.frame_tree.tree_getData(actStr)");

	// Ziel ist die Aktualisierungsfunktion im tree_frame:
	function tree_getData(actStr)
	{  }


*/

// ********************************************************************************************

// globale Variablen
var DEBUG_TREE = 0;
var treeDataObj;						// Tree-Daten, global	


// ********************************************************************************************


// Initialisierung der Seite
function initSide()
{

	// Tree nur im eigeloggten Zustand oeffnen
	if ((top.g_username == "Standard") ||
		(top.g_username == "Operator") ||	
		(top.g_username == "Administrator") )		
	{
		document.getElementById("treepos").style.display = "block";
	}
	else
		document.getElementById("treepos").style.display = "none";

	// Anlegen von Strukturen zum Speichern des Tree-Zustandes bei Refresh
	tree.initTreeNodes();
}

// ********************************************************************************************

// Antwortfunktion Anforderung TreeData
function tree_getData(actStr)
{

	if (DEBUG_TREE)	
		alert (actStr);

	// bisherigen Oeffnungszustand des Tree speichern
	if (treeStruc != undefined)
	{	
		tree.nodeArr = tree.getTreeNodes (treeStruc);
	}

	// JSON-String in Objekt wandeln
	var obj = treeDataObj = JSON2.parse(actStr);

	// Struktur des tree im array "treeStruc" speichern
	treeStruc = treeArr.createStruct(obj);
	//alert (treeStruc);

	// Namen in Ordnern konvertieren
	nameConversion (treeStruc);
	
	// treeStruc auswerten und tree aufbauen	
	tree.createTree (treeStruc);
	
	// Tree minimieren
	tree.resetTreeNodes (treeStruc);
	
	// gespeicherten Zustand des Tree wiederherstellen
	if (treeStruc != undefined)
		tree.setTreeNodes (tree.nodeArr);

	// Anzeige nach kurzer Zeit sichtbar machen
	setTimeout ("makeVisible()", 500);	

	// "Load Navigation ..." beenden
	document.getElementById("load").style.visibility = "hidden";
}

// Anzeige sichtbar machen
function makeVisible()
{
	document.getElementById("treepos").style.visibility = "visible";
	document.getElementById("deviceName").style.visibility = "visible";
}

// ********************************************************************************************

// Antwortfunktion Anforderung TreeData
// dabei wird der tree minimiert dargestellt; das ist immer dann noetig, wenn
// Tree-Elemente veraendert wurden (z.B. Entfernen von links)
function tree_getDataMinimized(actStr)
{
	// Refresh beenden
	shadeTree (0);

	if (DEBUG_TREE)	
		alert (actStr);

	// bisher geoeffnete Nodes speichern
	tree.nodeArr = tree.getTreeNodes (treeStruc);		// Speichern der Nodes
	
	// Ausgabe
	// printNodes (tree.nodeArr);	

	// HTML-Struktur des Tree zuruecksetzen
	resetTree();

	// JSON-String in Objekt wandeln
	var obj = JSON2.parse(actStr);

	// Struktur des tree im array "treeStruc" speichern
	treeStruc = treeArr.createStruct(obj);
	// alert (treeArr.showTreeNodes());
	
	// Namen in Ordnern konvertieren
	nameConversion (treeStruc);
	
	// treeStruc auswerten und tree aufbauen	
	tree.createTree (treeStruc);
	
	// Tree minimieren
	tree.resetTreeNodes (treeStruc);
}

// ********************************************************************************************

// Antwortfunktion Anforderung TreeData fuer links
function tree_getData_links(actStr)
{
	// Tree empfangen und minimieren
	tree_getDataMinimized(actStr);

	// Tree auf gewuenschte Groesse expandieren
	//tree.nodeArr[tree.nodeArr.length] = "Links." + ins("tree_connect");		// segment immer oeffnen

	// Ausgabe	
	// printNodes (tree.nodeArr);	

	tree.setTreeNodes (tree.nodeArr, treeStruc);			// Nodes wiederherstellen
}

// ********************************************************************************************

// Antwortfunktion Anforderung TreeData fuer application
function tree_getData_application(actStr)
{
	// Tree empfangen und minimieren
	tree_getDataMinimized(actStr);

	// Tree auf gewuenschte Groesse expandieren
	//tree.nodeArr[tree.nodeArr.length] = ins("tree_app") + "." + ins("tree_consisting");	// segment immer oeffnen

	// Ausgabe	
	// printNodes (tree.nodeArr);	

	tree.setTreeNodes (tree.nodeArr, treeStruc);		// Nodes wiederherstellen
}

// ********************************************************************************************

// Antwortfunktion Anforderung TreeData fuer MBus
function tree_getData_mbusConfiguration(actStr)
{
	// Tree empfangen und minimieren
	tree_getDataMinimized(actStr);

	// Tree auf gewuenschte Groesse expandieren
	//tree.nodeArr[tree.nodeArr.length] = "MBus." + ins("tree_config") + "." + ins("tree_counter");	// segment immer oeffnen

	// Ausgabe	
	// printNodes (tree.nodeArr);	

	tree.setTreeNodes (tree.nodeArr, treeStruc);		// Nodes wiederherstellen
}

// ********************************************************************************************










// ********************************************************************************************
// ********************************************************************************************

// Geraetenamen des EWIO setzen
function setDeviceName (name)
{
	document.getElementById("deviceName").innerHTML = name;
}

// ********************************************************************************************

// Geraetenamen des EWIO lesen
function getDeviceName ()
{
	var name = document.getElementById("deviceName").innerHTML;
	return name;
}

// ********************************************************************************************

// HTML-Struktur des Tree zuruecksetzen
function resetTree()
{	
	document.getElementById("tree_wrapper").innerHTML = "";
}

// ********************************************************************************************
// ********************************************************************************************

// Tree abschatten, Navigation refresh einblenden
function shadeTree (on)
{
	if (on)
	{
		document.getElementById("treepos").style.opacity = 0.4;
		document.getElementById("treepos").style.filter = 'alpha(opacity=40)';
		document.getElementById("refresh").style.visibility = 'visible';

	}
	else // off
	{
		document.getElementById("treepos").style.opacity = 1;
		document.getElementById("treepos").style.filter = 'alpha(opacity=100)';
		document.getElementById("refresh").style.visibility = 'hidden';
	
	}

}

// ********************************************************************************************
// ********************************************************************************************

// Mehrsprachigkeit
function nameConversion (treeStruc)
{
		// printTree (treeStruc);

		for (var i=0; i<treeStruc.length; i++)
		{
			// Array aus den Werten eines Eintrags bilden
			var nodeValues = treeStruc[i].split("|");
			var name_dir = nodeValues[2];
			var name_file = nodeValues[3];

			// Namen konvertieren
			// Ordner

			if (name_dir == "configuration")
				name_dir = ins("tree_config");
			if (name_dir == "device")
				name_dir = ins("tree_device");
			if (name_dir == "data")
				name_dir = ins("tree_data");
			if (name_dir == "IO_extended")
				name_dir = ins("tree_io_extended");
			if (name_dir == "applications")
				name_dir = ins("tree_app");
			if (name_dir == "general")
				name_dir = ins("tree_general");
			if (name_dir == "counter")
				name_dir = ins("tree_counter");
			if (name_dir == "connect_to")
				name_dir = ins("tree_connect");
			if (name_dir == "new_app")
				name_dir = ins("tree_new");
			if (name_dir == "consisting")
				name_dir = ins("tree_consisting");
			if (name_dir == "data_server")
				name_dir = ins("tree_data_server");
			if (name_dir == "data_server_general")
				name_dir = ins("tree_general");
			if (name_dir == "data_server_cyclic")
				name_dir = ins("tree_data_server_cyclic");
			if (name_dir == "data_server_man")
				name_dir = ins("tree_data_server_man");
			if (name_dir == "file_transfer")
				name_dir = ins("tree_file_transfer");


			
			// Dateien
			if (name_file == "devicebase")
				name_file = ins("tree_devicebase");
			if (name_file == "memory")
				name_file = ins("tree_memory");
			if (name_file == "log")
				name_file = ins("tree_log");
			if (name_file == "password")
				name_file = ins("tree_pw");
			if (name_file == "ip_addresses")
				name_file = ins("tree_ip");
			if (name_file == "time_management")
				name_file = ins("tree_time");
			if (name_file == "email")
				name_file = ins("tree_email");
			if (name_file == "add_counter")
				name_file = ins("tree_add_counter");
			if (name_file == "remove_counter")
				name_file = ins("tree_remove_counter");
			if (name_file == "counter_secAddress")
				name_file = ins("tree_counter_secAddress");
			if (name_file == "counter_primAddress")
				name_file = ins("tree_counter_primAddress");
			if (name_file == "counterlist")
				name_file = ins("tree_counterlist");
			if (name_file == "syncpulse")
				name_file = ins("tree_sync_pulse");
			if (name_file == "parameter output")
				name_file = ins("tree_param_output");
			if (name_file == "tariffs")
				name_file = ins("tree_tariffs");
			if (name_file == "hallo")
				name_file = ins("tree_hallo");
			if (name_file == "messages")
				name_file = ins("tree_messages");
			if (name_file == "hallo")
				name_file = ins("tree_hallo");
			if (name_file == "messages")
				name_file = ins("tree_messages");
			if (name_file == "format")
				name_file = ins("tree_format");
			if (name_file == "type")
				name_file = ins("tree_type");
			if (name_file == "datapoints")
				name_file = ins("tree_datapoints");
			if (name_file == "configuration")
				name_file = ins("tree_config");
			if (name_file == "data")
				name_file = ins("tree_data");
			if (name_file == "BACnet Configuration")
				name_file = ins("tree_bacnet_conf");


			
			// geaenderten Namen einfuegen
			treeStruc[i] = nodeValues[0] + "|" + nodeValues[1] + "|" + name_dir + "|" + name_file;
		}

		// printTree (treeStruc);		
}

// ********************************************************************************************

// treeStruc ausgeben
function printTree (treeStruc)
{
		var str = "";
		for (var i=0; i<treeStruc.length; i++)
			str += "tree von "+i+" = "+treeStruc[i]+"\n";
		alert (str);
}

// ********************************************************************************************

// Nodes ausgeben
function printNodes (nodeArr)
{
	var str = "";
	for (var i=0; i<nodeArr.length; i++)
		str += (nodeArr[i] + "\n");
	alert ("Gespeicherte Knoten: \n\n" + str);
}

// ********************************************************************************************
// ********************************************************************************************


