/*
	R.S. 06/2011

	tree.js
	Erzeugen und Steuern eines Navigationsbaumes
	===============================================================================================
	
	Tree erzeugen	
	=============
	Vorlage erzeugen:
	Als Basis fuer den Tree dient ein JSON-Objekt (obj).
	Dieses kann auf zwei Arten erzeugt werden:
		- als String mit anschliessendem Umwandeln in ein Objekt
		- als Objekt (empfohlen).
	
	Tree-Struktur erzeugen:
	Aus dem JSON-Objekt wird ein Array erzeugt, welches die Struktur des Tree
	enthaelt (treeStruc).
		treeStruc = treeArr.createStruct(obj);

	Tree erzeugen:
	Dazu wird das Array treeStruc ausgewertet und der Tree aufgebaut.	
		tree.createTree (treeStruc);
		
	Tree minimieren:	
		tree.resetTreeNodes (treeStruc);
	Diese Funktion wird fuer gewoehnlich nach dem Aufbau des Tree aufgerufen, 
	um den Tree in seinen Auslieferungszustand zu versetzen.


	Steuerung
	=========
	Mit Hilfe der Steuerung koennen Zustaende von Knoten gespeichert und wiederhergestellt werden.
	Beachten: Die Wiederherstellung ist nur aus einem komplett minimierten Tree erfolgreich!
	Anwendungsbeispiel: 
	Der Nutzer hat den Tree in eine Verzweigung geoeffnet.
	Jetzt soll der Tree modifiziert und danach neu geladen werden. 
	Dabei soll die geoeffnete Verzweigung wiederhergestellt werden.
	Ablauf:
	
		- tree.nodeArr = tree.getTreeNodes (treeStruc);		// Speichern der Nodes
		- Neuladen des Tree
		- tree.resetTreeNodes (treeStruc);				// Tree minimieren
		- tree.setTreeNodes (tree.nodeArr, treeStruc);		// Nodes wiederherstellen

	Moeglich ist auch das Oeffnen des Trees an einer vorher festgelegten Stelle.
	Dazu muss nach der Minimierung das tree.nodeArr gesetzt werden und 
		tree.setTreeNodes (tree.nodeArr, treeStruc);
	aufgerufen werden.	
		

	Grafik, Schrift		
	==============
	Es koennen verschiedene Grafiken fuer die Darstellung benutzt werden.
	Dazu einfach den img-Ordner wechseln.
	Beispiel:
	Verwendung der Grafiken im WIN-7-Stil:
	aktuellen img-Ordner loeschen, eine Kopie von img_modern anlegen und diese in img umbenennen	

	Fuer die Pages koennen beliebige Zeichen verwendet werden.
	Fuer die Ordner gilt das so nicht, da sie als Strukturbezeichner im JSON verwendet werden.
	Zeichen in Ordnern konvertieren:
		treeStruc = tree.charConversion (treeStruc);	
	Deutsche Umlaute koennen in JSON verwendet werden (  , ).
	Leerzeichen werden als Unterstrich eingegeben und zu Leerzeichen konvertiert.
	
	Die Groesse von Icons und Schrift laesst sich in tree.css anpassen, ebenso die Schriftfarbe usw.
		
		
	Target
	======
	Als Ziel kann eine Web-Adresse angegeben werden:	
		target = "http://www.google.de"
	oder auch eine Webseite innerhalb des eigenen Projekts:
		target = "target.html";
	Fuer die Webseite innerhalb des eigenen Projekts muss ein Frame mit Namen "frame_content" angelegt werden.	
	
	
	Browserspezifisches
	===================
	- Google Chrome hat eine sehr strikte Ueberwachung, dass IFrames von der gleichen WebSide stammen wie die
	  Eltern-Seite. Das fuehrt beim lokalen Test mit Files dazu, dass Variablen von der Elternseite als "undefined"
	  bezeichnet werden (z.B. Abruf treePageName). Erst bei einem Test via Server (z.B. Apache) werden diese Variablen 
	  korrekt aufgeloest.
	  Bei FF und IE funktioniert die Aufloesung auch mit Files!
	  
	
	Varianten
	=========
	- Neben den sichtbaren Struktruelementen (Icon, Text, Target) koennen auch zusaetzliche Daten innerhalb eines Arrays
	  vereinbart werden. Diese koennen dann beim Anklicken des Eintrags mit uebertragen werden (Beispiel: "info").
	- Man koennte neben Icon, Text und Target noch eine Zeile mit einer frei definierbaren Klasse einfuegen, z.B. "textStyle".
	  Dort koennte man als class verschiedene Textstyle-Varianten aufrufen und so die Schriftart im Tree variieren.
	  Die class muesste als Parameter in "addElement_div" eingesetzt werden bzw. nachtraeglich gesetzt werden.
	  
	  
	 Einschraenkungen
	================
	Alle Elemente innerhalb eines Arrays werden fr die Darstellung eines Eintrags benutzt.
	Daher ist es auch nicht zulaessig, innerhalb eines Arrays einen neuen Ordner anzulegen.
	  
*/

// ********************************************************************************************
// ********************************************************************************************

// globale Variablen
var treeStruc;						// Tree-Struktur, global	
var	treePageName = new Array();		// Texteintraege des ausgewaehlten Knotens


// ********************************************************************************************
// treeArr
// ********************************************************************************************

// Erzeugung eines tree- Arrays aus einem JSON-Objekt
// Aufbau der Baumstruktur:
// nodeId | parentNodeId | nodeName | nodeUrl
/*
	Beispiel Struktur:
	Tree[0]  = "1|0|Konfiguration|#";
	Tree[1]  = "2|1|Allgemeine Einstellungen|#";
	Tree[2]  = "3|1|IOs|#";
	Tree[3]  = "4|3|IO 01|config_01.html";
	Tree[4]  = "5|3|IO 02|config_02.html";
	Tree[5]  = "6|3|IO 03|#";
	Tree[6]  = "7|3|IO 04|#";
	Tree[7]  = "8|3|IO 05|#";
	Tree[8]  = "9|3|IO 06|#";
	Tree[9]  = "10|3|IO 07|#";
	Tree[10]  = "11|3|IO 08|#";

	Beispiel Aufruf:
	var treeStruc = treeArr.createStruct(obj);
	
*/
var treeArr = 
{
	// Variablen, gueltig innerhalb von treeArr
	debug: 0,			// Ausgaben
	parentNode: 0,		// Parent-Node in Tree
	nodeInArr: 0,		// Zaehler fuer Knoten innerhalb von Array-Elementen
	node: new Array(),	// Zaehler fuer Knoten in Tree
	lineCnt: 0,			// Zaehler fuer Zeilennummer von Tree
	Tree: new Array(),	// Baumstruktur 
	
	// ========================================================================
	// Ergaenzung 06/2011:
	// Aufruf mit Objektuebergabe vereinfacht
	createStruct: function(obj)
	{
		this.treeObj = obj;								// Objekt uebergeben
		this.Tree = this.initTreeNodes("treeObj");		// Objektnamen uebergeben
		return this.Tree;
	},
	
	// ========================================================================
	// ========================================================================
	// Initialisierung und Erzeugung der Baumstruktur
	initTreeNodes: function(objName)
	{
		// Initialisierung
		this.parentNode = 0;
		this.nodeInArr = 0;
		this.lineCnt = 0;
		this.node[this.lineCnt] = 0;
	
		// Wenn vorher bereits ein Tree bestand, diesen loeschen
		if (this.Tree.length > 0)
			this.Tree.length = 0;
		
		// Analyse des Objekts und Konfigurierung des Tree
		var ret = this.sortObjects("this."+objName);
		if (ret == 0)
			alert ("Objekt nicht vollstndig aufgelst!")

		// Test		
		if (this.debug)	this.showTreeNodes();		
		
		// return: Rueckgabe der Baumstruktur
		return this.Tree;
	},

	// ========================================================================
	// ========================================================================
	// Debug: Ausgabe der Treenodes
	showTreeNodes: function ()
	{
		var str = "";
		for (var i=0; i<this.Tree.length; i++)
			str += "tree von "+i+" = "+this.Tree[i]+"\n";
		alert (str);
	},

	// ========================================================================
	// Objekte in Baumstruktur sortieren
	// param: Objektname (als String)
	// ret: 0 = Abbruch / 1 = OK
	sortObjects: function (objName)
	{
		var deb = 0;	// Debug- Ausgaben

		var arrAll;	// Array mit Objekten (arrAll[0]) und Eigenschaften (arrAll[1])
		var arr; 	// Array mit Objekten
		var val; 	// Array mit Eigenschaften
		var type;	// Typ des Objekts
		
	
		// Ermitteln der Elemente des Objekts (objName)
		var obj = eval(objName);

		// Array ?
		if (obj[0])
		{			
			type = "array";
			arr = obj;
			if (deb) alert ("aktuelles Objekt = array");
		}
		else
		{
			type = "object";
			arrAll = this.getObjectsAsArray(obj);
			arr = arrAll[0];
			val = arrAll[1];
			if (deb) alert ("aktuelles Objekt = object");
		}
	
		if (arr == 0)
			return 0;	// Abbruch: kein Objekt oder Property
		
		// Bearbeiten der einzelnen Elemente
		for (var i=0; i<arr.length; i++)
		{
			if  (type == "object")
				obj = eval(objName+"."+arr[i]);			// Object
			else
				// type == "array"
				obj = eval(objName+"["+i+"]");			// Array
		
			// Baumstruktur erzeugen
			if (typeof obj == "object")
			{
				if (type == "array")
				{
					//										Zeile (Knoten) 		|	Elternknoten	| 	Name	|	Inhalt			
					this.Tree[this.Tree.length] = (this.Tree.length+1)+"|"+(this.parentNode)+"|["+i+"]|#";
				}
				else
				{
					this.Tree[this.Tree.length] = (this.Tree.length+1)+"|"+(this.parentNode)+"|"+arr[i]+"|#";
				}
			}
			else
			{
				if (type == "array")
				{	
					this.Tree[this.Tree.length] = (this.Tree.length+1)+"|"+(this.parentNode)+"|["+i+"]"+"|"+arr[i];
				}
				else
				{	
					this.Tree[this.Tree.length] = (this.Tree.length+1)+"|"+(this.parentNode)+"|"+arr[i]+"|"+val[i];
				}
			}
			
			if (deb) alert ("parentNode = "+this.parentNode+"    "+i+". Element = "+arr[i]+"\n");
	

			// Element ist wiederum ein Objekt (object oder array)	?
			// array
			if (type == "array")					
			{
				if (typeof arr[i] == "object")		// Objekt im Array
				{
					// Node fuer Tree- Darstellung
					this.nodeInArr++;
					this.lineCnt++;
					this.parentNode = this.Tree.length;
					this.node[this.lineCnt] = this.Tree.length-1;
					if (deb) alert ("Array Node ++, node["+this.lineCnt+"] = "+this.node[this.lineCnt]);
				}
				else					// Eigenschaft
					continue;
			}
		
			// Naechstes Objekt
			// object
			var nextObj;
			if  (type == "object")
			{
				nextObj = objName+"."+arr[i];
				obj = eval(objName+"."+arr[i]);		// Object
			}
			else
			{
				// type == "array"
				nextObj = objName+"["+i+"]";
				obj = eval(objName+"["+i+"]");		// Array
			}
		
			// weder noch
			if (obj == null)
				return 0;
			
			// Ist naechstes Element ein Objekt? Dann rekursiv weiter.	
			if (typeof obj == "object")
			{
				// Node fuer Array zuruecksetzen
				if (this.nodeInArr)
				{
					this.lineCnt--;
					this.nodeInArr--;
				}	

				// Node fuer Tree- Darstellung
				this.lineCnt++;
				this.parentNode = this.Tree.length;
				this.node[this.lineCnt] = this.Tree.length;
				if (deb) alert ("Node ++, node["+this.lineCnt+"] = "+this.node[this.lineCnt]);

				// Rekursiver Aufruf		
				var ret = this.sortObjects (nextObj);
				if (ret == 0)
					return 0;
			}
		}
	
		// Node zuruecksetzen: kein untergeordnetes Objekt mehr
		this.lineCnt--; 
		this.parentNode = this.node[this.lineCnt];
		if (deb) alert ("Node --, aktueller Node = node["+this.lineCnt+"] = "+this.node[this.lineCnt]);
	
		return 1;
	},
	
	// ========================================================================
	// Ermitteln aller Teilobjekte und Eigenschaften innerhalb eines angegebenen Objektes
	// param: Objekt 
	// ret: Array mit enthaltenen Teil-Objekten und Eigenschaften
	getObjectsAsArray: function (obj)
	{
		var prop = "";
		var i = 0;
	
		var arr = new Array();
		arr[0] = new Array();
		arr[1] = new Array();
	
		// Objekt vorhanden?
		if ( (typeof(obj) == "undefined") || (obj === null) ) 
			return (0);
		
		// Eigenschaft als string
		if (typeof(obj) == "string") 
			return (obj);

		// Eigenschaft als number -> string
		if (typeof(obj) == "number") 
			return (obj+"");

		// Objekt	
		if (typeof(obj) == "object")
		{
			for (prop in obj)
			{
				arr[0][i] = prop; 
				arr[1][i] = obj[prop];
				i++;
			}
		}
		return (arr);	// arr[0] enthaelt objekte, arr[1] enthaelt Eigenschaften
	}	
}

// ********************************************************************************************
// ********************************************************************************************





// ********************************************************************************************
// tree
// ********************************************************************************************

var tree = 
{
	// Variablen, gueltig innerhalb von treeArr
	debug: 0,					// Ausgaben
	nodeArr: new Array(),		// Array fuer Knoten
	icons: new Array(),			// Array fuer verwendete Icons

	xScroll: 0,					// Scroll-Parameter
	yScroll: 0,
	
	// ========================================================================

	//Laden aller im Tree verwendeten Icons
	preloadIcons: function()
	{
		this.icons[0] = new Image();
		this.icons[0].src = "tree/img/plus.gif";
		this.icons[1] = new Image();
		this.icons[1].src = "tree/img/plusbottom.gif";
		this.icons[2] = new Image();
		this.icons[2].src = "tree/img/minus.gif";
		this.icons[3] = new Image();
		this.icons[3].src = "tree/img/minusbottom.gif";
		this.icons[4] = new Image();
		this.icons[4].src = "tree/img/folder.gif";
		this.icons[5] = new Image();
		this.icons[5].src = "tree/img/folderopen.gif";
	},

	// ========================================================================
	// Aufbau Tree
	createTree: function(treeStruc)
	{
		var text = "";			
		var info = "";			// optional
		var info_1 = "";		// optional
		var info_2 = "";		// optional
		var info_3 = "";		// optional
		var arrLine = 0;
		
		if (treeStruc.length > 0) 
		{
			this.preloadIcons();
		
			// Kopf
			this.addElement_div ("tree_wrapper", "tree_head", "child", ""); 
			document.getElementById("tree_head").innerHTML = '<img src="tree/img/folder.gif" align="absbottom"> EWIO-M ';

			// Inhalt
			for (var i=0; i<treeStruc.length; i++)
			{
				// Array aus den Werten eines Eintrags bilden
				var nodeValues = treeStruc[i].split("|");
			
				// Klassifizierung der Elemente
				var type;
				if (nodeValues[2].indexOf("[") == 0)	
					type = "array";
				else if (nodeValues[3] == "#")
					type = "dir";
				else if (nodeValues[2] == "icon")
					type = "icon";
				else if (nodeValues[2] == "text")
					type = "text";
				else if (nodeValues[2] == "target")
					type = "target";
				// optional
				else if (nodeValues[2] == "info")
					type = "info";
				else if (nodeValues[2] == "info_1")
					type = "info_1";
				else if (nodeValues[2] == "info_2")
					type = "info_2";
				else if (nodeValues[2] == "info_3")
					type = "info_3";
					
						
				var index = ""; 
				switch (type)
				{
					case "dir":
						// div dynamisch erzeugen
						if (arrLine == 0)
						{
							index ="z" + nodeValues[0]; 
							this.addElement_div ("tree_wrapper", index, "child", ""); 
						
							document.getElementById(index).innerHTML = "";

							// horizontale Positionierung
							var hp_arr = this.h_position (treeStruc, nodeValues[0]);
							for (var j=0; j<hp_arr.length; j++)
							{
								if (hp_arr[j] == "line")
									document.getElementById(index).innerHTML += '<img src="tree/img/line.gif" align="absbottom">';
								else
									document.getElementById(index).innerHTML += '<img src="tree/img/empty.gif" align="absbottom">';
							}
						}
						else
						{
							// Beachten: alle Elemente, welche ein "onClick = ..." enthalten, sollten kein <a href="#"> enthalten, weil dass zu einem
							// Neuaufbau der Seite fuehrt (Baum wird auf Anfang gescrollt)!

							index ="z" + arrLine; 
							var lastSib = this.lastSibling (treeStruc, nodeValues[0], nodeValues[1]);
							if (lastSib)
								document.getElementById(index).innerHTML += '<img id="join'+nodeValues[0]+'" src="tree/img/minusbottom.gif" align="absbottom"  onClick="tree.oc('+nodeValues[0]+',1);">';
							else
								document.getElementById(index).innerHTML += '<img id="join'+nodeValues[0]+'" src="tree/img/minus.gif" align="absbottom" onClick="tree.oc('+nodeValues[0]+',0);">';
							document.getElementById(index).innerHTML += '<a href="' + nodeValues[3] + '" align="absbottom"><img src="tree/img/folderopen.gif" align="absbottom"/>' + nodeValues[2] + '</a>';
							break;
						}
						
						// Wenn letzter Knoten, dann Join ohne weiterfuehrende Linie verwenden
						var lastSib = this.lastSibling (treeStruc, nodeValues[0], nodeValues[1]);
						if (lastSib)
							document.getElementById(index).innerHTML += '<img id="join' + nodeValues[0] + '" src="tree/img/minusbottom.gif" align="absbottom"  onClick = "tree.oc('+nodeValues[0]+',1);">';
	
						else
							document.getElementById(index).innerHTML += '<img id="join' + nodeValues[0] + '" src="tree/img/minus.gif" align="absbottom" onClick = "tree.oc('+nodeValues[0]+',0);">';
						
						// Um zu verhindern, dass Ordnernamen einen Neuaufbeu der Seite veranlassen, werden diese ohne "a href" eingefuegt							
						if (nodeValues[3] == "#")
							document.getElementById(index).innerHTML += '<img src="tree/img/folderopen.gif" align="absbottom"/>' + nodeValues[2];
						else
							document.getElementById(index).innerHTML += '<a href="' + nodeValues[3] + '" align="absbottom"><img src="tree/img/folderopen.gif" align="absbottom"/>' + nodeValues[2] + '</a>';
	
						if (this.debug)		
						{
							alert (type+"  "+index);
							alert ("dir: "+nodeValues[2]+"   len: "+hp_arr.length+"   "+hp_arr);
							alert (document.getElementById(index).innerHTML);
						}
						break;
					
					case "array":
						// div dynamisch erzeugen
						index ="z" + nodeValues[0]; 
						arrLine = nodeValues[0];
						this.addElement_div ("tree_wrapper", index, "child", ""); 
					
						document.getElementById(index).innerHTML = "";
		
						// horizontale Positionierung
						var hp_arr = this.h_position (treeStruc, nodeValues[0]);
						for (var j=0; j<hp_arr.length; j++)
						{
							if (hp_arr[j] == "line")
								document.getElementById(index).innerHTML += '<img src="tree/img/line.gif" align="absbottom">';
							else
								document.getElementById(index).innerHTML += '<img src="tree/img/empty.gif" align="absbottom">';
						}

						// letztes Element ?	
						var lastSib = this.lastSibling (treeStruc, nodeValues[0], nodeValues[1]);
						if (lastSib)
							document.getElementById(index).innerHTML += '<img src="tree/img/joinbottom.gif" border="0">';
						else
							document.getElementById(index).innerHTML += '<img src="tree/img/join.gif" border="0">';
						if (this.debug)
						{			
							alert (type+"  "+index);
							alert ("arr: "+nodeValues[2]+"   len: "+hp_arr.length+"   "+hp_arr);
							alert (document.getElementById(index).innerHTML);
						}
						break;
					
					case "icon":
						index ="z" + arrLine; 
						document.getElementById(index).innerHTML += '<img src="tree/img/' + nodeValues[3] + '" align="absbottom" border="0">';
						if (this.debug)
							alert (type+"  "+index);
						break;

					case "text":			
						// text wird erst unter "target" eingefuegt und bis dahin zwischengespeichert
						text = nodeValues[3];
						if (this.debug)
							alert (type+"  "+index);
						break;

					// optional: ein Daten-Attribut, welches aber nicht dargestellt wird	
					case "info":
						// info wird erst unter "target" eingefuegt und bis dahin zwischengespeichert
						info = nodeValues[3];
						if (this.debug)
							alert (type+"  "+index);
						break;	
						
					case "info_1":
						info_1 = nodeValues[3];
						break;	

					case "info_2":
						info_2 = nodeValues[3];
						break;	

					case "info_3":
						info_3 = nodeValues[3];
						break;	

					case "target":
						index ="z" + arrLine; 
					
						// <a href="#"> fuehrt zu Neuaufbau der Seite (Baum wird auf Anfang gescrollt), darum <a href="javascript:void(0)"> nutzen
						document.getElementById(index).innerHTML += "<a href=\"javascript:void(0)\" style=\"text-decoration:none\" onmouseover=\"window.status='" + nodeValues[3] + 
																	"';return true;\" onmouseout=\"window.status=' ';return true;\" onClick=\"tree.getNewPage('"+nodeValues[3]+"','" + 
																	text+"','"+info+"','"+info_1+"','"+info_2+"','"+info_3+"');\">" + text + "</a>";
						if (this.debug)
						{		
							alert (type+"  "+index);
							alert (document.getElementById(index).innerHTML);
						}
						arrLine = 0;
						break;
				}		
			}
		}
	},
	
	// ========================================================================
	// Einen Knoten oeffnen oder schliessen
	oc: function(node, bottom) 
	{
		var minus;
		var join = document.getElementById("join" + node);
		if (bottom == 0) 
		{
			if (join.src == this.icons[0].src)
			{		
				join.src = this.icons[2].src;
				minus = 1;
			}
			else
			{
				join.src = this.icons[0].src;
				minus = 0;
			}
		}
		else 
		{
			if (join.src == this.icons[1].src)
			{
				join.src = this.icons[3].src;
				minus = 1;
			}
			else
			{
				join.src = this.icons[1].src;
				minus = 0;
			}
		}		

		// Aufruf der Zeilennummerberechnung, rekursiv
		this.calculateLine (treeStruc, node, minus);
	},
	
	// ========================================================================
	// Zeilennummer berechnen
	calculateLine: function(nodes, node, minus)	
	{
		for (var i=0; i<nodes.length; i++) 
		{
			var nodeValues = nodes[i].split("|");
			if (nodeValues[3] == "#") 
			{
				if (nodeValues[1] == node)
				{
					var line = "z"+nodeValues[0];
					//alert (line+"   "+minus);
						
					// Zeile anzeigen / ausblenden
					this.showLine (line, minus);
						
					// bei "plus" sollen alle untergeordneten Eintraege unsichtbar werden
					if (minus == 0)			
						this.calculateLine (nodes, nodeValues[0], 0);
					else		
					{
						// rekursiv in Unterverzeichnisse abtauchen, dabei +/- Knoten beachten
						var join = document.getElementById("join" + node);

						// weiter entsprechend +/- Knoten		
						if ((join.src == this.icons[2].src) || (join.src == this.icons[3].src))		// minus
						{
							// bei "minus" sollen nur die ausgeblendeten Eintraege unsichtbar werden	
							//alert ("join"+node+" = minus");
							this.calculateLine (nodes, nodeValues[0], 1);
						}		
						else
						{
							// bei "plus" sollen alle untergeordneten Eintraege unsichtbar werden
							//alert ("join"+node+" = plus");
							this.showLine (line, 0);
							this.calculateLine (nodes, nodeValues[0], 0);
						}		
					}
				}		
			}
		}
	},
	
	// ========================================================================
	// Zeilen ein-und ausblenden
	showLine: function(line, show)
	{
		if (show == 1)
			document.getElementById(line).style.display = "block";	
		else
			document.getElementById(line).style.display = "none";	
	},
	
	// ========================================================================
	// Pruefen, ob ein Knoten noch Geschwister hat oder ob er der Letzte ist
	lastSibling: function(nodes, node, parentNode) 
	{
		var lastChild = 0;
		for (i=0; i< nodes.length; i++) 
		{
			var nodeValues = nodes[i].split("|");
			if (nodeValues[1] == parentNode)
				lastChild = nodeValues[0];
		}
		if (lastChild==node) 
			return true;
		return false;
	},

	// ========================================================================
	// Berechnung der horizontalen Schritte und deren Inhalt
	h_position: function(nodes, node)
	{
		var cntArr = new Array();
		var cnt = 0;

		while (1)
		{
			for (var i=0; i< nodes.length; i++) 
			{
				var nodeValues = nodes[i].split("|");
				if (nodeValues[0] == node)
				{
					var lastSib = this.lastSibling (nodes, nodeValues[0], nodeValues[1]);
					if (lastSib)
						cntArr[cnt] = "empty";
					else	
						cntArr[cnt] = "line";
					// alert (node+"   "+nodeValues[2]+"   "+lastSib);
					cnt++;
					break;
				}		
			}

			if (nodeValues[1] == 0)
				break;
			else
			node = nodeValues[1];		
		}

		// Arrayeintraege in die benoetigte Reihenfolge wandeln
		var outArr = new Array();
		for (var i=0; i<(cntArr.length-1); i++)
			outArr[i] = cntArr[cntArr.length-1-i];

		// alert ("cnt:"+cnt+"   cntArr:"+cntArr+"   outArr:"+outArr);
		return outArr;
	},
	
	// ========================================================================
	// ========================================================================
	// einen voll geoeffneten tree komplett schliessen
	resetTreeNodes: function(treeStruc)
	{
		for (var i=0; i<treeStruc.length; i++)
		{
			// Array aus den Werten eines Eintrags bilden
			var nodeValues = treeStruc[i].split("|");

			var lastSib = this.lastSibling (treeStruc, nodeValues[0], nodeValues[1]);
			if (document.getElementById("join" + nodeValues[0]))
			{
				var join = document.getElementById("join" + nodeValues[0]);
				if (lastSib)
					join.src = this.icons[1].src;		// plus-bottom
				else
					join.src = this.icons[0].src;		// plus
				this.calculateLine (treeStruc, nodeValues[0], 0);
			}
		}
	},
	
	// ========================================================================
	// Array zum Speichern von Knotenzustaenden anlegen
	initTreeNodes:function()
	{
		this.nodeArr = new Array();
	},
	
	// ========================================================================
	// Knotenzustaende speichern
	// Ermitteln der Strukur der geoeffneten Nodes
	// geoeffnete Knoten werden im nodeArr als String in JSON-Objekt-Notation gespeichert
	getTreeNodes:function(treeStruc)
	{
		this.nodeArr.length = 0;
		var parentNode = -1;
		var str = "";
		var arrCnt = -1;
		var start = 0;
	
		for (var i=0; i<treeStruc.length; i++)
		{
			// Array aus den Werten eines Eintrags bilden
			var nodeValues = treeStruc[i].split("|");
			if (document.getElementById("join" + nodeValues[0]))
			{
				var join = document.getElementById("join" + nodeValues[0]);

				// minus-join, minus-bottom-join
				if ((join.src == this.icons[2].src) || (join.src == this.icons[3].src))
				{
					// alert ("minus: " + nodeValues);
					// alert (parentNode+"   "+nodeValues[1]);
					
					// wurde ein parent gefunden?
					if (parentNode == nodeValues[1])		
					{
						// child anfuegen
						str += ".";
						str += nodeValues[2];		
					}
					else
					{	
						// kein parent gefunden, Wurzel suchen
						var match = 1;
						str = "";
						if (nodeValues[1] != 0)
						{
							var nodeValuesBefore = nodeValues;
							do
							{
								// parent suchen, bis Wurzel erreicht ist
								nodeValuesBefore = this.getNodeValuesBefore (treeStruc, nodeValuesBefore);
							
								// ist unter den parents ein plus, dann Abbruch (der geoeffnete Knoten ist verdeckt!)		
								join = document.getElementById("join" + nodeValuesBefore[0]);
								if ((join.src == this.icons[0].src) || (join.src == this.icons[1].src))
									match = 0;

								str = nodeValuesBefore[2] + "." + str;
							}
							while (nodeValuesBefore[1] != 0)
						}
					
						// Abbruch, weil der geoeffnete Knoten verdeckt ist
						if (!match)
							continue;
					
						str += nodeValues[2];
						arrCnt++;
					}
					this.nodeArr[arrCnt] = str;
					parentNode = nodeValues[0];		
				}
			}
		}
		return this.nodeArr;
	},

	// ========================================================================
	// Knotenzustaende setzen
	// Beachten:
	// Wiederherstellung von Knoten nur nach vollstaendiger Minmierung des Trees erfolgreich !
	// im nodeArr gespeicherte Knoten werden geoeffnet
	setTreeNodes:function(nodeArr, treeStruc)
	{
		for (var arrCnt=0; arrCnt<nodeArr.length; arrCnt++)
		{
			var nodes = this.nodeArr[arrCnt].split(".");
			for (var i=0; i<nodes.length; i++)
			{
				for (var j=0; j<treeStruc.length; j++)
				{	
					if (treeStruc[j] == undefined)
					{
						alert ("Error while setting tree nodes: " + nodes[i]); 	
						break;
					}
					var nodeValues = treeStruc[j].split("|");
					if (document.getElementById("join" + nodeValues[0]))
					{
						if (nodes[i] == nodeValues[2])
						{
							// Pruefen, ob die vorhergehenden Nodes uebereinstimmen	
							var match = 1;	
							var nCnt = i;
							if (nodeValues[1] != 0)
							{
								var nodeValuesBefore = nodeValues;
								while (nCnt)
								{
									nCnt--;
									// parent suchen
									nodeValuesBefore = this.getNodeValuesBefore (treeStruc, nodeValuesBefore);
									if (nodeValuesBefore[2] != nodes[nCnt])
									{
										match = 0;
										break;
									}
								}
							}	
									
							// Uebereinstimmung aller Knotenelemente, Knoten expandieren
							if (match)
							{
								// alert (nodeValuesBefore+"   "+nodeValues+"   "+nodes+"   "+i);			

								var join = document.getElementById("join" + nodeValues[0]);
								var lastSib = this.lastSibling (treeStruc, nodeValues[0], nodeValues[1]);

								if (lastSib)
									join.src = this.icons[3].src;		// minus-bottom
								else
									join.src = this.icons[2].src;		// minus
								this.calculateLine (treeStruc, nodeValues[0], 1);
								break;
							}
						}	
					}
				}
			}
		}
	},

	// ========================================================================
	// Hilfsfunktion fuer getTreeNodes(), setTreeNodes()
	getNodeValuesBefore:function (treeStruc, nodeParent)
	{
		for (var i=treeStruc.length-1; i>=0; i--)
		{
			// Array aus den Werten eines Eintrags bilden
			var nodeValues = treeStruc[i].split("|");
			if (nodeParent[1] == nodeValues[0])
				return nodeValues;
		}
	},
	
	// ========================================================================
	// ========================================================================
	// Zeichenkonvertierung fuer Ordner im Tree
	// es wird konvertiert:
	// "_"  -> " "		
	charConversion:function(treeStruc)
	{

		for (var i=0; i<treeStruc.length; i++)
		{
			// Array aus den Werten eines Eintrags bilden
			var nodeValues = treeStruc[i].split("|");
			var name = nodeValues[2];

			// Namen konvertieren
			name = name.replace(/_/g, " ");		// "_"  ->  " " 
			
			// geaenderten Namen einfuegen
			treeStruc[i] = nodeValues[0] + "|" + nodeValues[1] + "|" + name + "|" + nodeValues[3];
		}
		
		return treeStruc;
	},
	
	// ========================================================================
	// Seite oeffnen und Namen der geoeffneten Seite verfuegbar machen
	getNewPage: function(page, name, info, info_1, info_2, info_3)
	{
		// alert (name+"   "+page);
		
		if (!name || !page)
			return;

		// Namen global verfuegbar machen		
		treePageName[0] = name;
		
		// optional: Daten global verfuegbar machen
		treePageName[1] = info;							// MBus-Id

		// optional: Angaben bei der Zaehlersuche
		treePageName[2] = info_1;						// BusType
		treePageName[3] = info_2;						// SubBusType
		treePageName[4] = info_3;						// Baudrate

		// wenn string "http" enthaelt, dann Seite aufrufen
		if (page.indexOf("http") != -1)
		{
			top.window.location.href = page;
			return;
		}
		else
		{
			// wenn string "#" enthaelt, dann nichts tun (bereits geoeffneter Knoten!)
			if (page.indexOf("#") != -1)
				return;

			// page in Frame laden	
			if (top.frame_content)	
				top.frame_content.location.href = page +"?"+ top.package_version;
			else
				alert ("Kein Frame definiert!");
		}
	},

	// ========================================================================
	// ========================================================================
	// Dyn. Erzeugen eines HTML-Elements "div"
	addElement_div: function(parent_id, target_id, method, class_value) 
	{
		// Element erzeugen
		var newdiv = document.createElement ("div");
		
		// Attribute setzen
		newdiv.setAttribute('id', target_id);			
		if (class_value.length > 0)
			newdiv.setAttribute('class', class_value);		

		// weitere Attribute, z.B. Styles
		// ...

		// Element in DOM einhaengen
		if (parent_id == "document")
			var parent = document.body;
		else
			var parent = document.getElementById (parent_id);
		switch (method)
		{
			// als Geschwister anfuegen (unmittelbar vor parent)
			case "before": 
				var lastNode = parent.previousSibling;			
				parent.parentNode.insertBefore (newdiv, lastNode);
				break;
			
			// als Geschwister anfuegen (unmittelbar hinter parent)		
			case "next":	
				var nextNode = parent.nextSibling;				
				parent.parentNode.insertBefore (newdiv, nextNode);
				break;
		
			// am Grosselternelement anfuegen (z.B. am Schluss des document)
			case "last":
				parent.parentNode.appendChild (newdiv);			
				break;
		
			// am Elternelement anfuegen (innerhalb des divs "parent")
			case "child":
			default:
				parent.appendChild (newdiv);						
				break;
		}	
	},
	
	// ========================================================================
	// Scroll-Parameter ermitteln
	saveScrollPosition: function() 
	{
		if (typeof(window.pageYOffset) == 'number')
		{
			// Standard
			xScroll = window.pageXOffset;
			yScroll = window.pageYOffset;
		}
		else if (document.body && (document.body.scrollLeft || document.body.scrollTop))
		{
			// DOM
			xScroll = document.body.scrollLeft;
			yScroll = document.body.scrollTop;
		}
		else if (document.documentElement && (document.documentElement.scrollLeft || document.documentElement.scrollTop))
		{
			// bis IE8
			xScroll = document.documentElement.scrollLeft;
			yScroll = document.documentElement.scrollTop;
		}
	}

	// ========================================================================

}

// ********************************************************************************************
// ********************************************************************************************



