/**********************************************************************************************

	JS functions for time 

	Copyright (c) 2009 MCQ TECH GmbH (rstiawa@metz-connect.com)
	Version 1.2		08/2010

***********************************************************************************************/

var DEBUG_TIME = 0;
var interval = 0;		// globale Var. zum Stoppen von setInterval()
var localObject;

// ********************************************************************************************
// ********************************************************************************************
// Initialisierung beim Start der page: Daten aktualisieren
function initTime()
{
	// Nach dem Aufbau der page sollen die Felder mit den Eigenschaften des Objekts gefuellt werden
	top.document.getElementById("button_1").onclick();

	// Namen der Page ermitteln
	document.getElementById("headLine").innerHTML = 
	getFilenameFromPath (top.frame_content.location.href);
	
	// Titel setzen
	var headLine = document.getElementById("headLine");		
	var page = top.tree_getPageName(); 	
	headLine.innerHTML = page[0];

	// Zeitzone-Listenfeld dynamisch fuellen
	initTZList ();
	
	// Buttonbeschriftung
	initButtons();
}

// ********************************************************************************************
// Aufruf der Aktualisierungsfunktionen
function setObjectProperties (actObject)
{
	// Werte setzen	
	setTime (actObject);	

	// Objekt global speichern fuer getObjectProperties()
	localObject = actObject;		
}

// ********************************************************************************************
// Aufruf der Aktualisierungsfunktionen
function getObjectProperties()
{
	// Nur Administrator sendet
	if (top.g_username == "Administrator")
	{	
		// Werte ermitteln	
		var changedObject = getTime(localObject);
		return (changedObject);
	}
	else
	{
		// MessageBox
		top.messageBox_Login ("Administrator");
		return;	
	}
}

// ********************************************************************************************
// ********************************************************************************************
// Werte aus dem JSON-Objekt setzen

// Werte fuer EWIO-Zeit entsprechend JSON-Objekt setzen
function setTime (jObject)
{
	// Einstellungen enstsprechend JSON- Objekt setzen
	// GMT und local time
	var time_local = document.getElementById("time_local");
	time_local.innerHTML = jObject.local;

	var time_gmt = document.getElementById("time_gmt");
	time_gmt.innerHTML = jObject.gmt;

	// Timezone
	var index = getTZIndex (jObject.tz_area);
	document.form_7.select.selectedIndex = index;
	updateTZ(index);
	
	// Art der Zeitstellung setzen
	for (var i=0; i<3; i++)
	{
		if (document.form_1.t0[i].value == jObject.syncType)
			document.form_1.t0[i].checked = true;
	}
	// Gesetzte Art der Zeitstellung initialisieren
	checkType();	
	
	// TimeServer
	for (var i=0; i<jObject.server_list.length; i++)
	{
		document.form_3.select[i].text = jObject.server_list[i].name;
	}
	document.form_3.select.selectedIndex = jObject.server.index;
	
	// Backup-Server
	for (var i=0; i<jObject.server_list.length; i++)
	{
		document.form_4.select[i].text = jObject.server_list[i].name;
	}
	document.form_4.select.selectedIndex = jObject.backup.index;
	
	// TimeServer-Liste darstellen
	var serverStr = "";
	for (var i=0; i<jObject.server_list.length; i++)
	{
		serverStr += jObject.server_list[i].name+",";
		serverStr += jObject.server_list[i].protocol;
		if (i<jObject.server_list.length-1)			serverStr += "\n";
	}
	document.form_6a.list.value = serverStr;
	
	// TimeServer- Abrufzeit
	var st_arr = jObject.server_time.split(" ");
	var time_arr = st_arr[1].split(":");
	document.form_5.hour.value = time_arr[0];
	document.form_5.min.value = time_arr[1];

	// TimeServer sofort abrufen ?
	if (jObject.get_server_time_now == true)
		document.form_5.checkTimeServer.checked = true;
	else
		document.form_5.checkTimeServer.checked = false;
}

// ********************************************************************************************
// Zeitzone

// Zeitzone-Listenfeld dynamisch fuellen
function initTZList ()
{
	var tzList = document.form_7.select;
	tzList.options.length = 0;
	for (var i=0; i<tz.length; i++)
	{
		// Listenelemente dynamisch hinzufuegen
		tzList.options[tzList.options.length] = 
			new Option (tz[i].split("|")[0], tz[i].split("|")[1], false, false);
	}
	tzList.selectedIndex = 0;
}

// Input-Feld mit ausgewaehltem Eintrag fuellen
function updateTZ(index)
{
	if (document.form_7.select[index])
	{
		var text = document.form_7.select[index].text;
		var val = document.form_7.select[index].value;
		// alert (text+"   "+val);
		document.form_7.tz.value = text;
	}
}

// Bereich "Zeitzone waehlen" enable / disable
function setTZ ()
{
	if (document.form_7.style.display == "block")
		document.form_7.style.display = "none";
	else
		document.form_7.style.display = "block";
}

// Index anhand eines Eintrags suchen
function getTZIndex (entry)
{
	for (var i=0; i<tz.length; i++)
	{
		if (entry == tz[i].split("|")[0])
		break;
	}
	return (i);
}

// ********************************************************************************************
// ********************************************************************************************

// Auswertung, welche Art der Zeitsetzung  der Nutzer gewhlt hat
function checkType()
{
	var type = "";
	
	for (var i=0; i<3; i++)
	{
		if (document.form_1.t0[i].checked == true)
			type = document.form_1.t0[i].value;
	}
	// alert (type);
	
	switch (type)
	{
		default:
		case "manual":
			displayTimeServer ("none");
			document.form_2.style.display = "block";
			clearInterval (interval);
			break;
		case "PC":
			// PC-Datum jede Sekunde aktualisieren
			displayTimeServer ("none");
			document.form_2.style.display = "block";
			// Anzeige sofort und danach alle 1000ms
			getPCTime('form_2');
			clearInterval (interval);
			interval = setInterval("getPCTime('form_2')", 1000);
			break;
		case "timeserver":
			document.form_2.style.display = "none";
			displayTimeServer ("block");
			clearInterval (interval);
			break;
	}
}

// ********************************************************************************************

// Timeserver- Einstellungen sichtbar /unsichtbar
function displayTimeServer (state)
{
	document.form_3.style.display = state;
	document.form_3a.style.display = state;
	document.form_4.style.display = state;
	document.form_4a.style.display = state;
	document.form_5.style.display = state;
	document.form_6.style.display = state;
	
	if (state == "none")
		document.form_6a.style.display = state;
}
// ********************************************************************************************

// PC- Datum ausgeben
function getPCTime (form)
{
	var datum = new Date();
	var element = eval("document."+form);

	element.year.value = setLeadNull (datum.getFullYear()%100-0);	// Jahreszahl 2-stellig
	element.month.value = setLeadNull (datum.getMonth()+1-0);		// getMonth() von 0 ... 11
	element.date.value = setLeadNull (datum.getDate()-0);
	element.hours.value = setLeadNull (datum.getHours()-0);
	element.minutes.value = setLeadNull (datum.getMinutes()-0);
	element.seconds.value = setLeadNull (datum.getSeconds()-0);
}

// ********************************************************************************************
// ********************************************************************************************

// TimeServer-Liste sichtbar machen
function setNewList ()
{

	if (document.form_6a.style.display == "block")
		document.form_6a.style.display = "none";
	else
		document.form_6a.style.display = "block";
}

// ********************************************************************************************
// ********************************************************************************************

// Werte fuer Zeit ermitteln und in JSON-Objekt setzen
function getTime (jObject)
{

	// Timezone
	var index = document.form_7.select.selectedIndex;
	jObject.tz_area = document.form_7.select[index].text;
	jObject.tz_value = document.form_7.select[index].value;

	// Art der Zeitstellung	
	for (var i=0; i<3; i++)
	{
		if (document.form_1.t0[i].checked == true)
			jObject.syncType = document.form_1.t0[i].value;
	}
	
	// gmt, local
	if (jObject.syncType != "timeserver")
	{
		// Laufzeitausgleich (x Sekunden addieren)
		var x = 3;	
		if ((document.form_2.seconds.value-0) <= (59 - x))
			document.form_2.seconds.value = parseInt(document.form_2.seconds.value) + x;
		else
			document.form_2.seconds.value = 59;

		// PC, manual
		// lokale Zeit ermitteln
		var year = setLeadNull (document.form_2.year.value-0);		
		var month = setLeadNull (document.form_2.month.value-0);		
		var date = setLeadNull (document.form_2.date.value-0);		
		var hours = setLeadNull (document.form_2.hours.value-0);		
		var minutes = setLeadNull (document.form_2.minutes.value-0);		
		var seconds = setLeadNull (document.form_2.seconds.value-0);		

		// Eingaben checken
		var ret = checkTimeComponents (date, "day");
		ret |= checkTimeComponents (month, "month");
		ret |= checkTimeComponents (year, "year");
		ret |= checkTimeComponents (hours, "hours");
		ret |= checkTimeComponents (minutes, "minutes");
		ret |= checkTimeComponents (seconds, "seconds");
		if (ret != -1)
			jObject.local = date+"."+month+"."+year+" "+hours+":"+minutes+":"+seconds;
		
		// gmt wird im EWIO berechnet, leeren String uebergeben
		jObject.gmt = "";
	}
	else
	{
		// Zeiten werden vom EWIO mittels timeserver eingetragen, 
		// keine Aenderung an den Eintraegen
	}

	// TimeServer-Angaben
	// Index Time-Server, Backup-Server
	jObject.server.index = document.form_3.select.selectedIndex;
	jObject.backup.index = document.form_4.select.selectedIndex;
	
	// Liste
	// Umwandeln der einzelnen Stringelemente in die JSON- Struktur
	var serverStr = document.form_6a.list.value;
	var listArr = serverStr.split("\n");				// Eintrag

	var listLength = listArr.length;
	if (listLength > 8)		listLength = 8;				// max. 8 Eintraege!

	var lineArr;										// Elemente einer Zeile
	var ipArr;											// Elemente einer IP-Adresse

	for (var i=0; i<listLength; i++)
	{
		lineArr = listArr[i].split(",");
		if (lineArr.length != 2)
		{
			clearListLine (jObject, i);
			continue;
		}
		// Name
		jObject.server_list[i].name = lineArr[0];		

		// Protokoll
		lineArr[1] = lineArr[1].replace(/\r/g, "");			// beseitigen "\r"
		jObject.server_list[i].protocol = lineArr[1]+"";	

	}
	// Bei weniger als 8 Eintraegen restliche Elemente ungueltig machen
	for (var i=listLength; i<8; i++)
		clearListLine (jObject, i);
	
	// Abrufzeitpunkt
	var hours = setLeadNull (document.form_5.hour.value-0);
	var minutes = setLeadNull (document.form_5.min.value-0);

	// Eingaben checken
	var ret = checkTimeComponents (hours, "hours");
	ret |= checkTimeComponents (minutes, "minutes");
	if (ret != -1)
		jObject.server_time = "01.01.01 "+hours+":"+minutes+":"+"00";

	// TimeServer sofort abrufen ?
	if (document.form_5.checkTimeServer.checked == true)
		jObject.get_server_time_now = true;
	else
		jObject.get_server_time_now = false;

	// Countdown setzen	
	time_setCountdown ();

	return (jObject);
}

// ********************************************************************************************

// Zeile in der Liste loeschen
function clearListLine (jObject, index)
{
	// Name
	jObject.server_list[index].name = "NO ENTRY";		
	// IP- Adresse
	for (var k=0; k<4; k++)
		jObject.server_list[index].ip[k] = "0";
	// Protokoll
	jObject.server_list[index].protocol = "?";	
	return jObject;
}

// ********************************************************************************************

// Fuehrende Null setzen (bei zweistelligem Wert, z.B. min, sec etc.)
function setLeadNull (value)
{
	value = (value < 10) ? "0"+value : value;
	return (value);
}

// ********************************************************************************************

// Zeiteingaben ueberpruefen
function checkTimeComponents (timeComp, check)
{
	var type = "";


	switch (check)
	{
		case "year":	if ((isFinite (timeComp) == false) || (timeComp-0 < 0) || (timeComp-0 > 38))
							type = ins("calendar_error_year");	// "Jahr" 
						break;

		case "month":	if ((isFinite (timeComp) == false) || (timeComp-0 < 1) || (timeComp-0 > 12))
							type = ins("calendar_error_month");	// "Monat" 
						break;

		case "day":		if ((isFinite (timeComp) == false) || (timeComp-0 < 1) || (timeComp-0 > 31))
							type = ins("calendar_error_day");	// "Tag" 
						break;

		case "hours":	if ((isFinite (timeComp) == false) || (timeComp-0 < 0) || (timeComp-0 > 24))
							type = ins("calendar_error_hour");	// "Stunde" 
						break;

		case "minutes":	if ((isFinite (timeComp) == false) || (timeComp-0 < 0) || (timeComp-0 > 59))
							type = ins("calendar_error_minute");	// "Minute" 
						break;

		case "seconds":	if ((isFinite (timeComp) == false) || (timeComp-0 < 0) || (timeComp-0 > 59))
							type = ins("calendar_error_second");	// "Sekunde" 
						break;
	}

	if (type != "")
	{
		alert (ins("calendar_error_input") + type);
		return (-1);	
	}

	return (0);
}

// ********************************************************************************************
// Buttonbeschriftung fuer Mehrsprachigkeit
function initButtons ()
{
	document.form_6.newList.value = ins("time_newlist");
	document.form_7a.tz.value = ins("time_tz");
}

// ********************************************************************************************
// ********************************************************************************************

var int_time = 0;
var time_counter = 5;			// Zeit fuer Countdown


// Countdown-Message anzeigen fuer Zeit setzen
function time_setCountdown ()
{

	var headline = '<B>'+ins("time_hd_setTime")+'</B>';
	content =		'<form name="form_setTime">'+ 		
					'<div class="pos x0101 textfield">'+ins("time_wait_setTime")+'</div>'+
					'<div class="pos x0401">'+
					'<input type="text" name="countdown" class="textfield_show" size="30" readonly="readonly" value="">'+		
					'</div>'+
					'</form>';
	
	guiPopup.Show ("message", headline, content, 'Info', 400, 140, "window");

	// Countdown-String aktualisieren
	int_time = setInterval ('time_countDownCalculator()', 1000);
}


function time_countDownCalculator ()
{

	var str = ""+ ins("time_wait_setTimeInSec") + time_counter;
	if (document.form_setTime.countdown)	
		document.form_setTime.countdown.value = str;

	time_counter--;
	if (time_counter < 0)
	{
		time_counter = 5;	
		clearInterval (int_time);
	
		// countdown-pad schliessen
		guiPopup.CloseMe("message");
	}
}

// ********************************************************************************************
// ********************************************************************************************

