/**********************************************************************************************

	JS functions for pw 

	Copyright (c) 2008 MCQ TECH GmbH (rstiawa@metz-connect.com)
	Version 1.2		08.2010

***********************************************************************************************/
/*
	Anmerkungen:
*/


var DEBUG_PW = 0;


// ********************************************************************************************
// ********************************************************************************************
// Initialisierung
function initPw()
{
	// Nach dem Aufbau der page sollen die Felder mit den Eigenschaften des Objekts gefuellt werden
	top.document.getElementById("button_1").onclick();

	// Namen der Page ermitteln
	document.getElementById("headLine").innerHTML = 
	getFilenameFromPath (top.frame_content.location.href);
	
	// Titel setzen
	var headLine = document.getElementById("headLine");		
	var page = top.tree_getPageName(); 	
	headLine.innerHTML = page[0];

	if (pw.getLoginState() == "Administrator")
		pw.setNewPw(true);
	else
		pw.setNewPw(false);
}

// ********************************************************************************************
// Aufruf der Aktualisierungsfunktionen (EWIO -> Browser)
function setObjectProperties (actObject)
{
	// Objekt global speichern fuer getObjectProperties()
	pw.localObject = actObject;	
}

// ********************************************************************************************
// Aufruf der Aktualisierungsfunktionen (Browser -> EWIO)
function getObjectProperties()
{

	// Nur Administrator sendet
	if (pw.getLoginState() == "Administrator")
	{
		// Werte ermitteln	
		var changedObject = pw.getLogIn(pw.localObject);
		return (changedObject);
	}
	else
	{
		// MessageBox
		top.messageBox_Login ("Administrator");
		return;	
	}
}

// ********************************************************************************************
// ********************************************************************************************

// Erzeugung eines pw- Objektes
// Alle Variablen und Funktionen zu diesem Objekt sind innerhalb des Objektes gekapselt
var pw = 
{
	// Variablen, gueltig innerhalb von pw
	localObject: 0,				// Objekt pw

	loginState: "Standard",		// Login- Status (Standard / Operator /Administrator)  	
	newPW_standard: "",		
	newPW_operator: "",			// neues Passwort Operator
	newPW_admin: "",			// neues Passwort Administrator
	user: "Standard",			// Auswahl ComboBox
	
	oldPW_root: "",				// altes Passwort Root
	newPW_root: "",				// neues Passwort Root

	// ========================================================================
	// ========================================================================
	// Ermitteln der Werte der LogIn-Aktion 
	// Wenn ein neues Passwort gesetzt wurde, wird dieses uebertragen
	getLogIn: function(object)
	{
		// Fehlermeldungen loeschen
		document.getElementById("result").innerHTML == "";
		document.getElementById("result_lin").innerHTML == "";

		// Passwort lokal gueltig machen
		this.setPwLocal();
		this.setLinPwLocal();

		// Objekt loeschen
		object.Standard = "";
		object.Operator = "";
		object.Administrator = "";
		object.Root_old = "";
 		object.Root_new = "";


		// Passwoerter webInterface in Objekt einfuegen
		if (this.newPW_standard != "")
			object.Standard = this.encryptPw (this.newPW_standard);

		if (this.newPW_operator != "")
			object.Operator = this.encryptPw (this.newPW_operator);

		if (this.newPW_admin != "")
			object.Administrator = this.encryptPw (this.newPW_admin);

		// Passwoerter Linux in Objekt einfuegen
		if (this.oldPW_root != "")
			object.Root_old = this.oldPW_root;

		if (this.newPW_root != "")
			object.Root_new = this.newPW_root;

		// kein Ergebnis abrufen, wenn Fehlermeldungen
		if ((document.getElementById("result").innerHTML != "") ||
			(document.getElementById("result_lin").innerHTML != ""))
			return (object);

		// Resultat der Passwortaenderung abholen
		if ((this.newPW_standard != "") || (this.newPW_operator != "") || (this.newPW_admin != "") ||
			(this.oldPW_root != "") || (this.newPW_root != ""))
			setTimeout ("top.getDataExtended ('pw', 'result', 'top.frame_content.pw_response(actStr)')", 2000);

		return (object);
	},

	// ========================================================================
	// ========================================================================
	// Nur im Administrator-Mode: Neues Passwort setzen
	// Textfelder fuer neues PW freischalten
	setNewPw: function (visible)
	{
		document.pw_group.pw0.disabled = !visible;
		document.pw_group.pw1.disabled = !visible;
		document.pw_group_lin.pw_old.disabled = !visible;
		document.pw_group_lin.pw0.disabled = !visible;
		document.pw_group_lin.pw1.disabled = !visible;
	},
	
	// ========================================================================
	// Passwort webInterface
	// ========================================================================
	// Ermitteln, fuer welchen State (Operator/Administrator) das Passwort geaendert werden soll
	selectState: function()
	{
		// get selected index
		var index = top.frame_content.document.selector.selectPw.selectedIndex;
		// get value
		var state = top.frame_content.document.selector.selectPw[index].text;
		return (state);
	},
	
	// ========================================================================
	// Auswertung der Eingabe des neuen PW
	getPassword: function()
	{
		// Password 1
		var pw1 = top.frame_content.document.pw_group.pw0.value;
		// Password 2
		var pw2 = top.frame_content.document.pw_group.pw1.value;

		// Passwort-Vergleich
		var success = document.getElementById("result");	// display	

		if ((pw1 == "") && (pw2 == ""))
		{
			success.innerHTML = "";
			return ("");									// keine Eingabe
		}
	
		if ((pw1 == pw2) && (pw1 != ""))
		{
			if (pw1.length < 2)
			{
				success.innerHTML =	ins("pw_error_min");	// Fehler: min. 2 Zeichen
				return ("");
			}	
	
			if (pw1.length > 16)
			{
				success.innerHTML =	ins("pw_error_max");	// Fehler: max. 16 Zeichen
				return ("");
			}	
	
			var result = this.checkInput (pw1);				
			if (result == -1)
			{
				success.innerHTML =	ins("pw_error_char");   // Fehler: nur AlphaNumeric und '_'
				return ("");
			}

			success.innerHTML =	"";				// OK
			return (pw1);
		}	
		
		success.innerHTML =	ins("pw_error_again");			// Fehler: Passwort-Wiederholung
		return ("");		
	},

	// ========================================================================
	// Eingabe checken:
	// Anzahl = 2 ... 16, AlphaNumerisch, keine Sonderzeichen, Unterstrich  
	// Return	0 = OK		-1 = Eingabefehler
	checkInput: function(inValue)
	{
		// check Inhalt
		var muster = /^[A-Za-z0-9_]{2,16}$/;
		var result = muster.test(inValue); 
		
		// alert (inValue+"   "+result);

		if (result == false)
			return (-1);

		return (0);
	},
	
	// ========================================================================
	// Neues Passwort innerhalb des Browsers speichern 
	setPwLocal: function()
	{
		// evtl. vorhandene Passwoerter loeschen
		newPW_standard: "";		
		newPW_operator: "";			
		newPW_admin: "";			

		var state = this.selectState();

		if (state == "Standard")
			this.newPW_standard = this.getPassword();	

		if (state == "Operator")
			this.newPW_operator = this.getPassword();	

		if (state == "Administrator")
			this.newPW_admin = this.getPassword();	
	},
	
	// ========================================================================
	// Evtl. vorhandene Passwoerter loeschen, Fehlermeldungen loeschen
	cleanPw: function()
	{
		document.pw_group.pw0.value = "";
		document.pw_group.pw1.value = "";

		document.getElementById("result").innerHTML = "";
	},




	// ========================================================================
	// Passwort Linux
	// ========================================================================
	// Auswertung der Eingabe des neuen PW
	getLinPassword: function()
	{
		// Passwort bisher
		var pw_old = top.frame_content.document.pw_group_lin.pw_old.value;
		// Passwort neu 0
		var pw0 = top.frame_content.document.pw_group_lin.pw0.value;
		// Password neu 1
		var pw1 = top.frame_content.document.pw_group_lin.pw1.value;

		var arrPw = new Array();			// Array pw old und new
		arrPw[0] = "";
		arrPw[1] = "";

		// Passwort-Vergleich
		var success = document.getElementById("result_lin");	// display	
		

		if ((pw0 == "") && (pw1 == ""))							
		{
			success.innerHTML =	"";								// keine Eingabe
			return (arrPw);										
		}
		
		if (pw_old == "")
		{
			success.innerHTML =	ins("pw_error_old");			// Fehler: Bisheriges Passwort fehlt
			return (arrPw);									
		}

		if ((pw0 == pw1) && (pw0 != ""))
		{
			if (pw0.length < 2)
			{
				success.innerHTML =	ins("pw_error_min");		// Fehler: min. 2 Zeichen
				return (arrPw);										
			}	
	
			if (pw0.length > 16)
			{
				success.innerHTML =	ins("pw_error_max");		// Fehler: max. 16 Zeichen
				return (arrPw);									
			}	

			var result = this.checkInput (pw0);				
			if (result == -1)
			{
				success.innerHTML =	ins("pw_error_char");   	// Fehler: nur AlphaNumeric und '_'
				return ("");
			}

			success.innerHTML =	"";
			arrPw[0] = pw_old;
			arrPw[1] = pw0;
		}	
		else
		{
			success.innerHTML =	ins("pw_error_again");			// Fehler: Passwort-Wiederholung
		}		
		return (arrPw);
	},
	
	// ========================================================================
	// Neues Passwort innerhalb des Browsers speichern 
	setLinPwLocal: function()
	{
		var arr;
		arr = this.getLinPassword();	

		this.oldPW_root = arr[0];	
		this.newPW_root = arr[1];	
	},
	
	// ========================================================================
	// Evtl. vorhandene Passwoerter loeschen, Fehlermeldungen loeschen
	cleanLinPw: function()
	{
		document.pw_group_lin.pw_old.value = "";
		document.pw_group_lin.pw0.value = "";
		document.pw_group_lin.pw1.value = "";

		document.getElementById("result_lin").innerHTML = "";
	},

	// ========================================================================
	// Passwort verschluesseln (AES)
	encryptPw: function(pw)
	{
		AES_Init();

		// text
		var block = new Array(16);
		var plaintext = pw;
		block = stringToByteArray (plaintext);	
		
		// key (Administratorpasswort)
		var key = new Array(32);
		var pw = top.g_password;
		key = stringToByteArray (pw);
		// key mit 0 auffuellen
		for(var i = pw.length; i < 32; i++)
			key[i] = 0;	
	
		if (DEBUG_PW)
			alert ("block: "+block+"\nkey: "+key);
	
		// Verschluesselung
		AES_ExpandKey(key);
		var cipherblock = AES_Encrypt(block, key);
	
		// ByteArray dezimal -> Hex-String
		var ciphertext = byteArrayToHex(cipherblock);

		if (DEBUG_PW)
	   		alert ("cipherblock: "+cipherblock+"\nciphertext: "+ciphertext);
	
		AES_Done();
		return (ciphertext);
	},

	// ========================================================================
	// LogIn-state ermitteln
	getLoginState: function()
	{
		return (top.g_username);
	}
}

// ********************************************************************************************
// Ergebnis des Passwort-Wechsels
function pw_response (actStr)
{
	// alert (actStr);
	top.messageBox (ins("main_mb_errMsg"), "<BR>" + top.getMessage (actStr));
	
	// Passwoerter und Auswertung loeschen
	pw.cleanPw ();
	pw.cleanLinPw ();
	document.getElementById("result").innerHTML = "";
	document.getElementById("result_lin").innerHTML = "";
}

// ********************************************************************************************
// ********************************************************************************************


