/**********************************************************************************************
	JS functions for param_data

	Copyright (c) 2012 MCQ TECH GmbH (rstiawa@metz-connect.com)
	Version 0.1		03.2012

***********************************************************************************************/


/*
	Anmerkungen:
*/

// ********************************************************************************************

var DEBUG_PARAM_DATA = 0;

var path_data = "/data/data_110926.sqlite";
var path_back = "/data/back_110926.sqlite";

// ********************************************************************************************
// ********************************************************************************************
// Initialisierung beim Start der page: Daten aktualisieren
function initSide()
{
	// Intervall ausblenden
	top.document.form_interval.style.display = "none";

	// Nach dem Aufbau der page sollen die Felder mit den Eigenschaften des Objekts gefuellt werden
	top.document.getElementById("button_1").onclick();

	// Titel setzen
	var headLine = document.getElementById("headLine");		
	var page = top.tree_getPageName(); 	
	headLine.innerHTML = "Transfer " + page[0];
}

// ********************************************************************************************
// Aufruf der Aktualisierungsfunktionen (EWIO-> Browser)
function setObjectProperties (actObject)
{
	// nicht verwendet
	return (0);
}

// ********************************************************************************************
// Aufruf der Aktualisierungsfunktionen (Browser -> EWIO)
function getObjectProperties()
{
	// nicht verwendet
	return (0);
}

// ********************************************************************************************
// ********************************************************************************************

// Werte lesen (EWIO -> Browser)
function param_dataFromEWIO (jObject)
{
	var type = "file_level";
	var module = path_data;
	var func = "top.frame_content.getLevel(actStr)";
	top.getDataExtended (module, type, func);
}

// ********************************************************************************************

// Button: Daten BROWSER -> EWIO
function param_dataToEWIO()
{
	// nicht verwendet, Message
	// "Hinweis", "Der Button \"BROWSER -> EWIO\" hat hier keine Funktion."	
	top.messageBox (ins("param_data_note_head"), ins("param_data_button_content")); 	
}

// ********************************************************************************************
// ********************************************************************************************

// Antwort vom EWIO
function getLevel(actStr)
{
	// kein JSON, also Fehlermeldung
	if (actStr.indexOf("{") == -1)
	{
		top.hideMessageBox();
		if (actStr.indexOf("LOGIN ERROR") != -1)	
		{
			// Wenn login-timeout abgelaufen ist, dann Fehlermeldung und Abbruch
			top.messageBox (ins("main_mb_errMsg"), ins("main_mb_errLogin")); 
		}
		else
		{
			// kein JSON, Ausgabe Fehlermeldung vom EWIO in MessageBox
			top.messageBox (ins("main_mb_errMsg"), top.getMessage (actStr));
		}
		return;
	}

	var obj = JSON2.parse(actStr);

	// Fuellstand gesamt
	setProgressValue ("form_all", obj.drive, obj.drive-obj.free);
	document["form_all"].info.value += ins("param_data_comp");

	// Maximale Groesse fuer Messwert- und Backdatei
	var free = (40 * obj.free) / 100;				// prozentualen Anteil berechnen
	free = Math.round(free);						// auf ganze Zahl runden

	// Back-Datei
	if (obj.back > free)
		obj.back = free;
	setProgressValue ("form_back", free, obj.back);

	// Messwert-Datei
	if (obj.data > free)
		obj.data = free;
	setProgressValue ("form_data", free, obj.data);

	// Laufwerkstyp
	document.form_base.info.value = obj.type;

}

// ********************************************************************************************
// ********************************************************************************************

// Progressbar setzen
function setProgressValue (name, all, used)
{
	var relUsed = (used * 100) / all;		// prozentualen Anteil berechnen
	relUsed = Math.round(relUsed);			// auf ganze Zahl runden

	// bar
	document.getElementById(name+"_graph").style.width = relUsed + "%";
	document.getElementById(name+"_text").innerHTML = relUsed + "%";

	// text
	all = getHumanReadableValue (all);
	used = getHumanReadableValue (used);

	// "Gesamt: " +all+ " / Belegt: " +used;
	document[name].info.value = ins("param_data_all") +all+ ins("param_data_used") +used;

}

// ********************************************************************************************

// Umwandeln von Speichergroessen (kB nach MB und GB)
function getHumanReadableValue (val)
{
	if (val > 1048576)		val = roundCommercial(val/1048576) + "GB";
	else if (val > 1024)	val = roundCommercial(val/1024) + "MB";
	else					val = val + "kB"
	return val;
}

// ********************************************************************************************

// Kaufmaennisches Runden (2 Stellen hinter dem Komma)
function roundCommercial (x)
{
	var k = (Math.round(x*100) / 100).toString();
	k += (k.indexOf('.') == -1)? '.00' : '00';
	var out = k.substring(0, k.indexOf('.') + 3);
	return out;
}

// ********************************************************************************************





// ********************************************************************************************
// Download
// ********************************************************************************************

// Download fuer Nicht-Text-Dateien (Filegroesse beliebig)   
function download_bin (type)
{ 
	// nur Administrator/Operator darf Aenderungen vornehmen
	if ((top.g_username != "Administrator") && (top.g_username != "Operator"))
	{
		top.messageBox_Login ("Administrator / Operator");
		return;
	}

	if (type == "back")		var target = ins("param_data_download_back");
	if (type == "value")	var target = ins("param_data_download_value");

	var headline =  '<B>DOWNLOAD</B>';
	var content =	'<div class="pos x0101 textfield"> '+target+
					'</div> '+
					'<form name="form_download" method="post" action="cgi-bin/getBinFileFromServer.cgi" accept-charset="utf-8"> '+ 		
						'<div class="pos x0301 textfield">'+
							'<input type="text" name="username" class="hidden" value="">'+
							'<input type="text" name="password" class="hidden" value="">'+
							'<input type="text" name="type" class="hidden" value="fileload_bin">'+
							'<input type="text" name="module" class="hidden" value="">'+
						'</div> '+
						'<div class="pos x0305"> '+
							'<input type="submit" class="textfield" value="DOWNLOAD" onclick= "setDownloadKey();message_timeout(5);loadingIconDownload();"> '+
						'</div> '+
						'<div class="pos top" id="form_download_icon" style="top:85px; left:360px;"> </div>'+
						'<div id="single_button_position">'+
							'<input type="button" class="single_button_ok" name="cancel" value="Cancel" onClick="message_close()">'+
						'</div>';
					'</form>'+

	guiPopup.Show ("message", headline, content, 'IO', 400, 150, "window");

	// module
	if (type == "back")		document.form_download.module.value = path_back;
	if (type == "value")	document.form_download.module.value = path_data;
}

// ********************************************************************************************
// Upload
// ********************************************************************************************

// Upload fuer Nicht-Text-Dateien (Filegroesse beliebig)   
function upload_bin (type)
{ 
	// nur Administrator/Operator darf Aenderungen vornehmen
	if ((top.g_username != "Administrator") && (top.g_username != "Operator"))
	{
		top.messageBox_Login ("Administrator / Operator");
		return;
	}

	if (type == "back")		var target = ins("param_data_upload_back");
	if (type == "value")	var target = ins("param_data_upload_value");

	var headline =  '<B>UPLOAD</B>';
	content =		'<div class="pos x0101 textfield"> '+target+
					'</div> '+ 		
					'<form name="form_upload" method="post" action="cgi-bin/setBinFileToServer.cgi" accept-charset="utf-8" enctype="multipart/form-data" onsubmit="return afterSubmit">'+
						'<div class="pos x0301 textfield">'+
							'<input type="text" name="username" class="hidden" value="">'+		
							'<input type="text" name="password" class="hidden" value="">'+	
							'<input type="text" name="type" class="hidden" value="fileload_bin">'+
							'<input type="text" name="module" class="hidden" value="">'+
							'<input type="file" name='+type+' accept="text/*" class="textfield" size="40"><br><br>'+
						'</div>'+
						'<div class="pos x0401"> <input type="submit" class="textfield" value="UPLOAD" onclick="setUploadKey();loadingIconUpload()"> </div>'+
						'<div class="pos top" id="form_upload_icon" style="top:110px; left:140px;"> </div>'+
						'<div id="single_button_position">'+
							'<input type="button" class="single_button_ok" name="cancel" value="Cancel" onClick="message_close()">'+
						'</div>'+
					'</form>';

	guiPopup.Show ("message", headline, content, 'Tools', 450, 180, "window");

	// module
	if (type == "back")		document.form_upload.module.value = "/data";
	if (type == "value")	document.form_upload.module.value = "/data";
}

// ********************************************************************************************

// Username und Passwort fuer Transaktion setzen
function setUploadKey ()
{
	// Parameter
	// username, password
	document.form_upload.username.value = top.g_username;
	var pw = top.calculatePassword ();
	document.form_upload.password.value = pw;
}

function setDownloadKey ()
{
	// Parameter
	// username, password
	document.form_download.username.value = top.g_username;
	var pw = top.calculatePassword ();
	document.form_download.password.value = pw;
}

// ********************************************************************************************

// nach dem submit ausfuehren
function afterSubmit ()
{
	guiPopup.CloseMe ("message");
}

// ********************************************************************************************

function loadingIconUpload()
{
	document.getElementById("form_upload_icon").style.backgroundImage = "url('style/loading_18.gif')";
	document.getElementById("form_upload_icon").style.backgroundRepeat = "no-repeat";
}

// ********************************************************************************************

function loadingIconDownload()
{
	document.getElementById("form_download_icon").style.backgroundImage = "url('style/loading_18.gif')";
	document.getElementById("form_download_icon").style.backgroundRepeat = "no-repeat";
}

// ********************************************************************************************

// Einstellung Datenbank-Parameter auswerten
function message_close ()
{
	// MessageBox schliessen
	guiPopup.CloseMe ("message");
}

// ********************************************************************************************

// Message entfernen nach Klick auf Download
function message_timeout (sec)
{
	setTimeout('message_close()', sec*1000);
}

// ********************************************************************************************
// ********************************************************************************************

// Info
function info_level()
{
	var headline =  '<B>INFO: '+ins("param_data_info_head")+' </B>';
	content =		'<div class="pos x0101 textfield">'+ins("param_data_info")+
					'</div>' +
					'<div id="button_position">'+
					'<input type="button" class="single_button_ok" name="ok" value="OK" onClick="info_close()">'+
					'</div>';
	
	guiPopup.Show ("info", headline, content, 'Info', 500, 150, "window");
}

// ********************************************************************************************

// INFO schliessen
function info_close()
{

	// pad schliessen
	guiPopup.CloseMe("info");
}

// ********************************************************************************************
// ********************************************************************************************




