/**********************************************************************************************
	JS functions for modbus_output.htm

	Copyright (c) 2012 MCQ TECH GmbH (rstiawa@metz-connect.com)
	Version 0.1		10.2012

***********************************************************************************************/


/*
	Anmerkungen:
	-
*/

// ********************************************************************************************

var DEBUG_MODBUS_OUTPUT = 0;
var path_output = "/var/mbus"

// ********************************************************************************************
// ********************************************************************************************

// Initialisierung beim Start der page: Zaehlerliste einlesen
function initSide()
{
	// Intervall ausblenden
	top.document.form_interval.style.display = "none";

	// Titel setzen
	var headLine = document.getElementById("headLine");		
	var page = top.tree_getPageName(); 	
	headLine.innerHTML = page[0];

	// alle konfigurierten Zähler auflisten
	top.getDataExtended ("modbus_output", "counter_list", "top.frame_content.modbus_getCounterList(actStr)");

	// Button disabeln
	top.document.getElementById("button_2").disabled = true;
}

// ********************************************************************************************
// ********************************************************************************************

// Button: Daten EWIO -> BROWSER
function modbus_dataFromEWIO()
{
	// ermitteln ausgewaehlten Zaehler
	var i = document.form_counter.select.selectedIndex;
	if (document.form_counter.select[i] == undefined)
		return;
	var BusAdr = document.form_counter.select[i].value;
	if (BusAdr == "no entry")
		return;

	// Parameter zum ausgewaehlten Zähler anfordern
	top.getDataExtended ("modbus_"+BusAdr, "output", "top.frame_content.modbus_getCounterOutput(actStr)");

	// Messagebox
	top.messageBox_Wait();
}

// ********************************************************************************************

// Button: Daten BROWSER -> EWIO
function modbus_dataToEWIO()
{
	// nur Administrator/Operator darf Zaehler loeschen
	if ((top.g_username != "Administrator") && (top.g_username != "Operator"))
	{
		top.messageBox_Login ("Administrator / Operator");
		return;
	}

	// Download-Prozedur starten 
	download();
}


// ********************************************************************************************
// ********************************************************************************************

// Antwort: Zaehler auflisten
function modbus_getCounterList(actStr)
{
	// Messagebox schliessen
	top.hideMessageBox();

	// wenn kein JSON -> Abbruch
	if (actStr.indexOf("{") == -1)
		return;

	// JSON-String in Objekt wandeln
	var jObject = JSON2.parse(actStr);
	for (var i=0; i<jObject.counter.length; i++)
	{
		// Eintrag in Liste
		if (jObject.counter[i].BusAdr == undefined)
		{	
			addSelectOption (document.form_counter.select, "no entry", "no entry");
			break;			
		}
		
		addSelectOption (document.form_counter.select, jObject.counter[i].BusAdr, jObject.counter[i].Name);
	}
}

// ********************************************************************************************

// Antwort: Parameter ausgeben
function modbus_getCounterOutput(actStr)
{
	// Messagebox schliessen
	top.hideMessageBox();

	// Parameter in Textbox
	var parameter = top.getMessage (actStr);
	document.form_text.content.value = parameter;

	// Button enabeln
	top.document.getElementById("button_2").disabled = false;

}

// ********************************************************************************************

// Der ausgewaehlte counter wurde geaendert
function changeSelectedCounter()
{
	// Parameterfeld loeschen
	document.form_text.content.value = "";
}

// ********************************************************************************************

// Hinzufuegen eines Eintrags innerhalb der Select-Box
function addSelectOption (parent, value, text)
{
	// Element erzeugen
	var newdiv = document.createElement("option");
	newdiv.setAttribute("value", value);	

	// Textinhalt		
	var textNode = document.createTextNode (text);
	newdiv.appendChild (textNode);

	// Element in SelectBox einfuegen
	parent.appendChild (newdiv);
}

// ********************************************************************************************






// ********************************************************************************************
// Download
// ********************************************************************************************

function download()
{ 

	// MessageBox schliessen
	top.hideMessageBox();

	// ermitteln ausgewaehlten Zaehler
	var i = document.form_counter.select.selectedIndex;
	if (document.form_counter.select[i] == undefined)
		return;
	var counterName = document.form_counter.select[i].text;
	if (counterName == "no entry")
		return;

	// FileNamen zusammenstellen (EWIO-Name + Zaehler-Name)
	var filename = path_output + "/" + top.getDeviceName() + "_" + counterName + ".txt";

	// Sonderzeichen kodieren
	filename = encodeURI (filename);
	// alert (filename);

	var headline =  '<B>DOWNLOAD</B>';
	var content =	'<div class="pos x0101 textfield"> '+ins("man_download_download")+
					'</div> '+

					'<form name="form_download" method="post" action="cgi-bin/getBinFileFromServer.cgi" accept-charset="utf-8"> '+ 		
						'<div class="pos x0301"> '+
							'<input type="submit" class="textfield" value="DOWNLOAD" onclick= "setParameter();"> '+
						'</div> '+
						'<div class="pos x0401 textfield">'+
							'<input type="text" name="username" class="hidden" value="">'+
							'<input type="text" name="password" class="hidden" value="">'+
							'<input type="text" name="type" class="hidden" value="fileload_bin">'+
							'<input type="text" name="module" class="hidden" value='+filename+'>'+ 
						'</div> '+
						'<div id="single_button_position">'+
							'<input type="button" class="single_button_ok" name="cancel" value="Cancel" onClick="download_close()">'+
						'</div>';
					'</form>'+

	guiPopup.Show ("message", headline, content, 'IO', 400, 150, "window");

	// Parameter
	// username, password
	// Parameter werden unter setParameter() gesetzt, damit das Passwort im Fall von Cancel nicht verworfen ist
	// und ein Logout bei der naechsten Kommunikation folgt
}

// ********************************************************************************************

// Parameter setzen nach Klick auf Download
function setParameter()
{
	document.form_download.username.value = top.g_username;
	document.form_download.password.value=top.calculatePassword ();
	setTimeout('download_close()', 1000);
}

// ********************************************************************************************

// Einstellung Datenbank-Parameter auswerten
function download_close ()
{
	// MessageBox schliessen
	guiPopup.CloseMe ("message");
}

// ********************************************************************************************








// ********************************************************************************************
// ********************************************************************************************
// Info
function info_download()
{
	var headline =  '<B>INFO: '+ins("mbus_output_info_head")+' </B>';
	content =		'<div class="pos x0101 textfield"> '+ins("mbus_output_info")+
					'</div>' +
					'<div id="button_position">'+
					'<input type="button" class="single_button_ok" name="ok" value="OK" onClick="info_close()">'+
					'</div>';
	
	guiPopup.Show ("info", headline, content, 'Info', 500, 180, "window");
}

// ********************************************************************************************
// INFO schliessen
function info_close()
{

	// pad schliessen
	guiPopup.CloseMe("info");
}

// ********************************************************************************************
// ********************************************************************************************



