/**********************************************************************************************
	JS functions for modbus_messages

	Copyright (c) 2011 MCQ TECH GmbH (rstiawa@metz-connect.com)
	Version 0.1		06.2011

***********************************************************************************************/


/*
	Anmerkungen:

*/

// ********************************************************************************************

var DEBUG_STAT = 1;
var dataSource = "modbusLog";		// Datenquelle (LogFile)

// ********************************************************************************************
// ********************************************************************************************
// Initialisierung beim Start der page: Daten aktualisieren
function initSide()
{
	// Intervall ausblenden
	top.document.form_interval.style.display = "none";

	// Titel anzeigen
	var name = top.tree_getPageName();
	document.getElementById("headLine").innerHTML = name[0];

	// Daten holen
	modbus_getData();

	// Button freigeben
	top.document.getElementById("button_1").disabled = false;
	top.document.getElementById("button_2").disabled = false;
}

// ********************************************************************************************
// Aufruf der Aktualisierungsfunktionen (EWIO-> Browser)
function setObjectProperties (actObject)
{
	// nicht verwendet
	return (0);
}

// ********************************************************************************************
// Aufruf der Aktualisierungsfunktionen (Browser -> EWIO)
function getObjectProperties()
{
	// nicht verwendet
	return (0);
}

// ********************************************************************************************
// ********************************************************************************************

// Button: Daten EWIO -> BROWSER
function modbus_dataFromEWIO()
{
	// Button fuer 1s disabeln
	top.document.getElementById("button_1").disabled = true;
	top.setTimeout ('buttonRelease("button_1")', 1000); 	

	// Daten vom Modbus abfragen
	modbus_getData();
}

// ********************************************************************************************

// Button: Daten BROWSER -> EWIO
function modbus_dataToEWIO()
{
	// nur Administrator/Operator darf Aenderungen vornehmen
	if ((top.g_username != "Administrator") && (top.g_username != "Operator"))
	{
		top.messageBox_Login ("Administrator / Operator");
		return;
	}

	// Button fuer 1s disabeln
	top.document.getElementById("button_2").disabled = true;
	top.setTimeout ('buttonRelease("button_2")', 1000); 	

	var oMessage = new Object();
	oMessage.delete_log = document.form_source.delete_log.checked;
	oMessage.delete_back = document.form_source.delete_back.checked;

	var objStr = JSON2.stringify (oMessage, null, 4);	// Object -> String
	top.setDataExtended ("modbus_log", "modbus_log", objStr);	
}


// ********************************************************************************************
// ********************************************************************************************

// Modbus-Messages vom EWIO lesen
function modbus_getData()
{
	// Message-File anfordern
	var module = "/config/usr/" + dataSource;
	top.getDataExtended (module, "fileload", "top.frame_content.modbus_getMessages(actStr)");
}

// ********************************************************************************************

// Message-File erhalten
function modbus_getMessages(actStr)
{
	// Inhalt vom Header trennen
	var content = top.getMessage (actStr);

	// Inhalt in Textfeld einfuegen
	var textarea = document.form_messages.messages;
	textarea.value = content;

	// zum Ende des Textfeldes scrollen
	textarea.scrollTop = textarea.scrollHeight; 
}

// ********************************************************************************************

// Auswahl Datenquelle (modbusLog / modbusLog.bac)
function setDataSource (source)
{
	// Datenquelle global speichern
	dataSource = source;
}

// ********************************************************************************************
// ********************************************************************************************








