/**********************************************************************************************
	JS functions for mbus_secAddress

	Copyright (c) 2011 MCQ TECH GmbH (rstiawa@metz-connect.com)
	Version 0.1		06.2013

***********************************************************************************************/


/*
	Anmerkungen:

*/

// ********************************************************************************************

var DEBUG_SECADDR = 0;

var counterObj;			// lokales Objekt zur Speicherung der zu loeschenden Zaehler
var oStr;				// Objekt zur Aktualisierung Tree
var cntMax;				// Anzahl der Eintraege

// ********************************************************************************************
// ********************************************************************************************
// Initialisierung beim Start der page: Daten aktualisieren
function initSide()
{
	// Intervall ausblenden
	top.document.form_interval.style.display = "none";

	// Nach dem Aufbau der page sollen die Felder mit den Eigenschaften des Objekts gefuellt werden
	top.document.getElementById("button_1").onclick();

	// Titel anzeigen
	var name = top.tree_getPageName();
	document.getElementById("headLine").innerHTML = name[0];
}

// ********************************************************************************************
// Aufruf der Aktualisierungsfunktionen (EWIO-> Browser)
function setObjectProperties (actObject)
{
	// nicht verwendet
	return (0);
}

// ********************************************************************************************
// Aufruf der Aktualisierungsfunktionen (Browser -> EWIO)
function getObjectProperties()
{
	// nicht verwendet
	return (0);
}

// ********************************************************************************************
// ********************************************************************************************
// Werte setzen
function setData (jObject)
{
	// nicht verwendet
}

// ********************************************************************************************
// Werte lesen
function getData (jObject)
{
	// nicht verwendet
}

// ********************************************************************************************
// ********************************************************************************************
// Button: Daten EWIO -> BROWSER
function mbus_dataFromEWIO()
{
	// Button disabeln
	top.document.getElementById("button_1").disabled = true;
	top.document.getElementById("button_2").disabled = true;

	// Ergebnis-Tabelle loeschen
	var tab = document.getElementById("tab_mbus_id");
	while (tab.rows.length > 0)
		tab.deleteRow(0);

	// alle konfigurierten und nichtkonfigurierten Zaehler anzeigen	
	mbus_getTreeConfig ();
}

// ********************************************************************************************
// Button: Daten BROWSER -> EWIO
function mbus_dataToEWIO()
{
	// nicht verwendet, Message
	// "Hinweis", "Der Button \"BROWSER -> EWIO\" hat hier keine Funktion."
	top.messageBox (ins("mbus_presence_button_head"), ins("mbus_presence_button_content")); 		
}


// ********************************************************************************************
// ********************************************************************************************
// alle konfigurierten und nichtkonfigurierten Zaehler anzeigen (aus tree)	
function mbus_getTreeConfig ()
{
	// Tabelle
	var tr, td;
	var tbody = document.getElementById("tab_mbus_id");

	// evtl. bereits vorhandene Zeilen loeschen
	while (tbody.rows.length > 0)
		tbody.deleteRow(0);

	var treeObj = top.frame_tree.treeDataObj;
	cntMax = treeObj.MBus.configuration.counter.length;	

	for (var i=0; i<cntMax; i++)	
	{
		//alert (treeObj.MBus.configuration.counter[i].text);

		var cnt = i+1;
		tr = tbody.insertRow(tbody.rows.length);		// neue Reihe

		// jede 2. Reihe andersfarbig ("Zebratabelle")
		if (tbody.rows.length % 2 == 0)	
			tr.setAttribute ("class", "row_color_odd");
		else
			tr.setAttribute ("class", "row_color_even");

		// 1. Spalte Name
		td = tr.insertCell(tr.cells.length);
		td.innerHTML = treeObj.MBus.configuration.counter[i].text;
		td.setAttribute ("class", "td_200");

		// 2. Spalte Bus-ID
		td = tr.insertCell(tr.cells.length);
		td.innerHTML = treeObj.MBus.configuration.counter[i].info;
		td.setAttribute ("class", "td_200");

		// 3. Spalte Checkbox
		td = tr.insertCell(tr.cells.length);

		if (treeObj.MBus.configuration.counter[i].info.indexOf("-SYS-") == -1)	// enthaelt kein "-SYS-" (intern)
			td.innerHTML = '<input type="button" name="config_'+(tbody.rows.length-1)+'" class="textfield_small" value="CHANGE" onclick="secAddress_configuration('+i+')">';
		td.setAttribute ("class", "td_100");
		td.setAttribute ("style", "text-align:center;");
	}

	// Liste fertig, Button freigeben
	top.document.getElementById("button_1").disabled = false;
	top.document.getElementById("button_2").disabled = false;
}

// ********************************************************************************************
// Sekundaeradresse konfigurieren
function secAddress_configuration (cnt)
{
	var adr = getTableElement ("tab_mbus_id", cnt, 1);

	var headline =  '<B>CHANGE SECONDARY ADDRESS</B>';
	var content =	'<form name="form_sec"> '+ 		
					'<div class="pos x0101 textfield"> '+ins("mbus_counter_secAdr_old")+'</div>'+
					'<div class="pos x0105 textfield"> '+
						'<input type="text" class="textfield" value="'+adr+'" name="sec_old" readonly="readonly" size="25" maxlength="20" style="text-align:center;">'+
					'</div>'+
					'<div class="pos x0201 textfield"> '+ins("mbus_counter_secAdr_new")+'</div>'+
					'<div class="pos x0205 textfield"> '+
						'<input type="text" class="textfield" value="" name="sec_new" size="25" maxlength="20" style="text-align:center;">'+
					'</div>'+
					'<div class="pos x0401"> Baudrate: </div>'+
					'<div class="pos x0403">'+
						'<input type="radio" name="rBr" value="300" > 300 Baud <br>'+
						'<input type="radio" name="rBr" value="600" > 600 Baud <br>'+
						'<input type="radio" name="rBr" value="1200" > 1200 Baud <br>'+
						'<input type="radio" name="rBr" value="2400"> 2400 Baud <br>'+
					'</div>'+
					'<div class="pos x0405">'+
						'<input type="radio" name="rBr" value="4800" > 4800 Baud <br>'+
						'<input type="radio" name="rBr" value="9600" checked="true"> 9600 Baud <br>'+
						'<input type="radio" name="rBr" value="19200" > 19200 Baud <br>'+
						'<input type="radio" name="rBr" value="38400" > 38400 Baud'+ 
					'</div>'+
					'<div id="button_position">'+
						'<input type="button" class="button_ok" name="ok" value="OK" onClick="fSetParam(1,'+cnt+')">'+
						'<input type="button" class="button_cancel" name="cancel" value="Cancel" onClick="fSetParam(0,'+cnt+')">'+
					'</div>'+
					'</form>';
	guiPopup.Show ("message", headline, content, 'IO', 450, 250, "window");
}

// ********************************************************************************************
// Sekundaeradresse pruefen
function fSetParam (valid, cnt)
{
	if (!valid)
	{
		// MessageBox schliessen
		guiPopup.CloseMe ("message");
		return;
	}

	// Parameter sind gueltig
	var secNew = document.form_sec.sec_new.value;

	// Pruefen, ob es sich um eine gueltige Sekundaeradresse handelt
	ret = checkSecAdrValid (secNew)
	if (ret == -1)
		return;

	// Pruefen, ob eingegebene Sekundaeradresse schon vorhanden ist - Warnung!
	for (var i=0; i<cntMax; i++)
	{
		if (getTableElement ("tab_mbus_id", i, 1) == secNew)
		{
			warningBox ("CHECK INPUT - Secondary Address", ins("mbus_counter_secAdr_exist"), cnt);			
			return;			
		}	
	}

	// Sekundaeradresse setzen
	prepareSecondaryAddress (1, cnt);
}


// ********************************************************************************************
// Ausgabe Warn-Box
function warningBox (headline, text, cnt)
{
	var content = 	text+
					'<div id="button_position">'+
					'<input type="button" class="button_ok" name="ok" value="OK" onClick="prepareSecondaryAddress(1, '+cnt+')">'+
					'<input type="button" class="button_cancel" name="cancel" value="Cancel" onClick="prepareSecondaryAddress(0, '+cnt+')">'+
					'</div>';
	guiPopup.Show ("message_warning", headline, content, 'Info', 400, 110, "window");
}

// ********************************************************************************************
// Auswertung Warn-Box, Setzen der Sekundaeradresse vorbereiten
function prepareSecondaryAddress (valid, cnt)
{
	if (valid)
	{
		// Sekundaeradresse setzen
		var secOld = getTableElement ("tab_mbus_id", cnt, 1);
		var secNew = document.form_sec.sec_new.value;
		setSecondaryAddress (secOld, secNew);
		guiPopup.CloseMe ("message");
	}
	else
		mbus_getTreeConfig ()	

	guiPopup.CloseMe ("message_warning");
}

// ********************************************************************************************
// Sekundaeradresse setzen
function setSecondaryAddress (secOld, secNew)
{
	var actObject = new Object();

	actObject.bus = mbus_path; 
	actObject.id = "0";
	for (var i=0; i<8; i++)
	{
		if (document.form_sec.rBr[i].checked == true)
			var br = document.form_sec.rBr[i].value;
	}
	actObject.br = br;			
	actObject.secAdr = secOld;
	actObject.command = "SETSECADR_" + secNew;
	actObject.param = "0";					

	var actStr = JSON2.stringify (actObject, null, 4);	// Object -> String
	top.setDataExtended ("mbus", "mbus", actStr);		// Daten zum EWIO senden (Telegramm Master->Slave)

	// Messagebox
	top.messageBox_Wait();
	setTimeout ("top.hideMessageBox()", 2000);

}
// ********************************************************************************************
// Pruefen, ob es sich um eine gueltige Sekundaeradresse handelt
function checkSecAdrValid (secAdr)
{
	var adrArr = secAdr.split("-");
	if (adrArr.length != 4)
	{
		top.messageBox ("CHECK INPUT - Secondary Address", ins("mbus_counter_secAdr_invalid")); 		
		return -1;	
	}

	var ret = top.checkInputString ("SECONDARY ADDRESS, Part 1", adrArr[0], "^[0-9]{8}$"); 	// Teil 1: 8 Ziffern
	if (ret == -1)
		return -1;

	var ret = top.checkInputString ("SECONDARY ADDRESS, Part 2", adrArr[1], "^[A-Z]{3}$"); 	// Teil 2: 3 Grossbuchstaben
	if (ret == -1)
		return -1;

	var ret = top.checkInputString ("SECONDARY ADDRESS, Part 3", adrArr[2], "^[0-9]{1,3}$"); 	// Teil 3: 1 .. 255
	if (ret == -1)
		return -1;

	var ret = top.checkInputString ("SECONDARY ADDRESS, Part 4", adrArr[3], "^[0-9]{1,3}$"); 	// Teil 3: 1 .. 255
	if (ret == -1)
		return -1;

	return 0;
}

// ********************************************************************************************
// ********************************************************************************************
// Eine Zelle in der Tabelle setzen
function setTableElement (table_id, row, cell, value)
{
	var parent = document.getElementById (table_id);
	parent.rows[row].cells[cell].innerHTML = value;
}

// ********************************************************************************************
// Eine Zelle in der Tabelle lesen
function getTableElement (table_id, row, cell)
{
	var table = document.getElementById (table_id);
	var result = table.rows[row].cells[cell].innerHTML;
	return (result);
}

// ********************************************************************************************
// ********************************************************************************************



