/**********************************************************************************************
	JS functions for mbus_config_datapoints

	Copyright (c) 2011 MCQ TECH GmbH (rstiawa@metz-connect.com)
	Version 0.1		07.2011

***********************************************************************************************/


/*
	Anmerkungen:

*/

// ********************************************************************************************

var DEBUG_DATA = 0;

// ********************************************************************************************
// ********************************************************************************************
// Initialisierung beim Start der page: Daten aktualisieren
function initSide()
{
	// Intervall ausblenden
	top.document.form_interval.style.display = "none";

	// Nach dem Aufbau der page sollen die Felder mit den Eigenschaften des Objekts gefuellt werden
	top.document.getElementById("button_1").onclick();

	// Titel setzen
	var headLine = document.getElementById("headLine");		
	var page = top.tree_getPageName(); 	
	headLine.innerHTML = page[0];
}

// ********************************************************************************************
// Aufruf der Aktualisierungsfunktionen (EWIO-> Browser)
function setObjectProperties (actObject)
{
	// nicht verwendet
	return (0);
}

// ********************************************************************************************
// Aufruf der Aktualisierungsfunktionen (Browser -> EWIO)
function getObjectProperties()
{
	// nicht verwendet
	return (0);
}

// ********************************************************************************************
// ********************************************************************************************
// Werte setzen
function setData (jObject)
{
	// nicht verwendet
}

// ********************************************************************************************
// Werte lesen
function getData (jObject)
{
	// nicht verwendet
}

// ********************************************************************************************
// ********************************************************************************************

// Button: Daten EWIO -> BROWSER
function mbus_dataFromEWIO()
{
	// Ergebnis-Tabelle loeschen
	var tab = document.getElementById("tab_mbus_id");
	while (tab.rows.length > 0)
		tab.deleteRow(0);

	// Button disabeln
	top.document.getElementById("button_1").disabled = true;

	// Messagebox
	top.messageBox_Wait();

	// channel lesen
	top.getDataExtended ("mbus", "channel_list", "top.frame_content.mbus_getChannel_answer(actStr)");
}

// ********************************************************************************************

// Antwort: Alle channel einlesen
function mbus_getChannel_answer(actStr)
{

	// alert (actStr);

	// Messagebox schliessen
	top.hideMessageBox();

	if (actStr.indexOf("{") == -1)
		return;

	// JSON-String in Objekt wandeln
	var jObject = JSON2.parse(actStr);

	// Ausgabe in Tabelle
	var tr, td;
	var tbody = document.getElementById("tab_mbus_id");

	if (jObject.channel[0].ID == undefined)
	{
		// keine Datenpunkte vorhanden
		// "Hinweis", "Es wurden keine Datenpunkte gefunden."
		top.messageBox (ins("mbus_datapoints_note_head"), ins("mbus_datapoints_no"));	

		// Button enabeln
		top.document.getElementById("button_1").disabled = false;
		return;
	}	

	// Tabelle aufbauen
	for (var i=0; i<jObject.channel.length; i++)
	{
		tr = tbody.insertRow(tbody.rows.length);		// neue Reihe

		// jede 2. Reihe andersfarbig ("Zebratabelle")
		if (tbody.rows.length % 2 == 0)	
			tr.setAttribute ("class", "row_color_odd");
		else
			tr.setAttribute ("class", "row_color_even");

		// 1. Spalte Channel-ID
		td = tr.insertCell(tr.cells.length);
		td.innerHTML = jObject.channel[i].ID;
		td.setAttribute ("class", "td_100");

		// 2. Spalte Bus
		td = tr.insertCell(tr.cells.length);
		td.innerHTML = jObject.bus[i].Kinds;
		td.setAttribute ("class", "td_50");

		// 3. Spalte BusAdr
		td = tr.insertCell(tr.cells.length);
		td.innerHTML = jObject.counter[i].BusAdr;
		td.setAttribute ("class", "td_150");

		// 4. Spalte Tel/Rec
		td = tr.insertCell(tr.cells.length);
		td.innerHTML = "Tel " + jObject.channel[i].Tele + " / Rec " +jObject.channel[i].Rec;
		td.setAttribute ("class", "td_100");

		// 5. Spalte Description
		td = tr.insertCell(tr.cells.length);
		td.innerHTML = jObject.channel[i].ZwTyp;
		td.setAttribute ("class", "td_180");

	}

	// Liste fertig, Button freigeben
	top.document.getElementById("button_1").disabled = false;
}

// ********************************************************************************************
// ********************************************************************************************

// Button: Daten BROWSER -> EWIO
function mbus_dataToEWIO()
{
	// nicht verwendet, Message
	// "Hinweis", "Der Button \"BROWSER -> EWIO\" hat hier keine Funktion."	
	top.messageBox (ins("mbus_datapoints_note_head"), ins("mbus_datapoints_button_content"));	
}

// ********************************************************************************************
// ********************************************************************************************
// Info
function info_valuelist()
{
	var headline =  '<B>INFO: '+ins("mbus_datapoints_info_head")+' </B>';
	content =		'<div class="pos x0101 textfield"> '+ins("mbus_datapoints_info")+
					'</div>' +
					'<div id="button_position">'+
					'<input type="button" class="single_button_ok" name="ok" value="OK" onClick="info_close()">'+
					'</div>';
	
	guiPopup.Show ("info", headline, content, 'Info', 500, 180, "window");
}

// ********************************************************************************************

// INFO schliessen
function info_close()
{

	// pad schliessen
	guiPopup.CloseMe("info");
}

// ********************************************************************************************
// ********************************************************************************************

