/**********************************************************************************************
	JS functions for mbus_auto

	Copyright (c) 2011 MCQ TECH GmbH (rstiawa@metz-connect.com)
	Version 0.1		05.2011

***********************************************************************************************/


/*
	Anmerkungen:

*/

// ********************************************************************************************

var DEBUG_DATA = 0;
var PRIM_RESET = 250;

var localObj;				// lokales Objekt 
var oConfig;				// Konfig-Objekt DB
var cnt_old = 0;			// statischer Zaehler in mbus_response()
var run_search = 0;			// Flag fuer laufende Suche
var tele_id;				// ID zur Zuordnung MBus Anfrage / Antwort
var mbus_timeout;			// Steuerung Intervall MBus-Abfrage
var search_br;				// Such-Baudrate

var counterIndex = 0;		// Index von Intervall 
var prim_timeout;			// Steuerung Intervall Reset Primaeradresse
var oStr;					// Aktualisierung Tree

// ********************************************************************************************
// ********************************************************************************************
// Initialisierung beim Start der page: Daten aktualisieren
function initSide()
{
	// Intervall ausblenden
	top.document.form_interval.style.display = "none";

	// Titel anzeigen
	var name = top.tree_getPageName();
	document.getElementById("headLine").innerHTML = name[0];

	// Elemente beschriften
	document.form_search_activate.button.value = ins("mbus_add_breakSearch");

	// Messagebox
	top.messageBox_Wait();

	// Button disabeln
	top.document.getElementById("button_1").disabled = true;
	top.document.getElementById("button_2").disabled = true;
	document.form_search_activate.button.disabled = true;

	// verfuegbare Busse scannen
	mbus_getBusList ();
}

// ********************************************************************************************
// Aufruf der Aktualisierungsfunktionen (EWIO-> Browser)
function setObjectProperties (actObject)
{
	// nicht verwendet
	return (0);
}

// ********************************************************************************************
// Aufruf der Aktualisierungsfunktionen (Browser -> EWIO)
function getObjectProperties()
{
	// nicht verwendet
	return (0);
}

// ********************************************************************************************
// ********************************************************************************************
// Werte setzen
function setData (jObject)
{
	// nicht verwendet
}

// ********************************************************************************************
// Werte lesen
function getData (jObject)
{
	// nicht verwendet
}

// ********************************************************************************************
// ********************************************************************************************

// Button: Daten EWIO -> BROWSER
function mbus_dataFromEWIO()
{
	// Button "Browser <- EWIO" disabeln
	top.document.getElementById("button_1").disabled = true;

	// Button "Suche abbrechen" enable
	document.form_search_activate.button.disabled = false;

	// Telegramm Master -> Slave fuer SlaveSearch
	mbus_request();
}

// ********************************************************************************************

// Button: Daten BROWSER -> EWIO
function mbus_dataToEWIO()
{
	// nur Administrator/Operator darf Zaehler hinzufuegen
	if ((top.g_username != "Administrator") && (top.g_username != "Operator"))
	{
		top.messageBox_Login ("Administrator / Operator");
		return;
	}

	// Button disabeln
	top.document.getElementById("button_2").disabled = true;

	// gefundene Zaehler in den Search-Abschnitt der Navigation einbauen
	mbus_addCounter();
}


// ********************************************************************************************
// ********************************************************************************************

// verfuegbare Busse scannen
function mbus_getBusList ()
{
	top.getDataExtended ("mbus_add_auto", "bus_list", "top.frame_content.mbus_getBusListAnswer(actStr)");
}

// ********************************************************************************************

// verfuegbare Busse scannen, Antwort
function mbus_getBusListAnswer(actStr)
{
	// kein JSON, also Fehlermeldung
	if (actStr.indexOf("{") == -1)
	{
		top.hideMessageBox();
		if (actStr.indexOf("LOGIN ERROR") != -1)	
		{
			// Wenn login-timeout abgelaufen ist, dann Fehlermeldung und Abbruch
			top.messageBox (ins("main_mb_errMsg"), ins("main_mb_errLogin")); 
		}
		else
		{
			// kein JSON, Ausgabe Fehlermeldung vom EWIO in MessageBox
			top.messageBox (ins("main_mb_errMsg"), top.getMessage (actStr));
		}
		return;
	}

	// Testausgabe
	if (DEBUG_DATA)	
		alert ("getBusListAnswer: \n"+actStr);


	// JSON-String in Objekt wandeln
	var jObject = JSON2.parse(actStr);
	
	for (var i=0; i<jObject.bus_driver.length; i++)
	{
		// Namen zerlegen
		var nameArr = jObject.bus_driver[i].split('.');

		// filtern Bus = 2 (MBUS)
		if (nameArr[2].slice(0,1) != 2)	
			continue;

		// Bus-Namen ermitteln
		var busname="";		
		switch (nameArr[2].slice(2,3))		
		{
			case "0":	busname = "mct_pin_di_";			break;
			case "1":	busname = "mct_spi_dio";		break;
			case "2":	busname = "mct_spi_aio";		break;
			case "3":	busname = "mct_paa_di4_";		break;
			case "4":	busname = "mct_paa_di10_";		break;
			case "5":	busname = "mct_paa_do4/to4_";	break;
			case "6":	busname = "mct_paa_dio42_";		break;
			case "7":	busname = "mct_paa_ai8_";		break;
			case "8":	busname = "mct_paa_ao4_";		break;
			case "9":   busname = "mct_paa_ai4_";		break;
		}

		// Slotplatz ermitteln
		if (busname.lastIndexOf("_") == (busname.length-1))		
			busname += nameArr[2].slice(4,5)

		// Instanz ermitteln
		if (nameArr[3] != "0")		
			busname += " " + nameArr[3]

		// Eintrag in Liste
		addSelectOption (document.form_bus.subBus, jObject.bus_path+"/"+jObject.bus_driver[i]+"/mbus", busname);

		if (DEBUG_DATA)	
			alert (jObject.bus_driver[i]+"   "+busname);
	}

	// Konfigurierte Zaehler ermitteln
	top.getDataExtended ("mbus_add_auto", "counter_list", "top.frame_content.mbus_getCounterList(actStr)");
}

// ********************************************************************************************

// Konfigurierte Zaehler ermitteln, Antwort
function mbus_getCounterList(actStr)
{
	// alert (actStr);

	// wenn kein JSON -> Abbruch
	if (actStr.indexOf("{") == -1)
		return;

	// JSON-String in Objekt wandeln
	oConfig = JSON2.parse(actStr);

	// Messagebox schliessen
	top.hideMessageBox();

	// Liste fertig, Button freigeben
	top.document.getElementById("button_1").disabled = false;

	// oConfig 		= Konfig-Angaben aus DB
	// localObject 	= Zaehler von SlaveSearch

	//alert (actStr);
}

// ********************************************************************************************

// checken, welcher bus ausgewaehlt wurde; 
// wenn mbus gewaehlt wurde, dann subbus-Selection deaktivieren
function checkBusSelection()
{
	var i = document.form_bus.bus.selectedIndex;
	var bus = document.form_bus.bus[i].value;
	if (bus == "MBus")
	{
		document.form_bus.subBus.style.visibility ="hidden";	
		document.form_baudrate.style.visibility ="visible";	
	}
	else
	{
		document.form_bus.subBus.style.visibility ="visible";	
		document.form_baudrate.style.visibility ="hidden";	
	}
}

// ********************************************************************************************





// ********************************************************************************************
// ********************************************************************************************

// Telegramm Master -> Slave senden
function mbus_request()
{

	// Telegramm nur senden, wenn nicht bereits eine Suche laeuft
	if (run_search == 1)
		return;

	// Anzeige aktualisieren
	run_search = 1;
	var search_state = document.getElementById("search_state");
	search_state.innerHTML = ins("mbus_add_searchOn") 			// "Suche laeuft"
	// setIntervalTime(toggleText, 1000);
	document.form_search_adr.searchAdr.value = "";

	// Ergebnis-Tabelle loeschen
	var tab = document.getElementById("tab_mbus_id");
	while (tab.rows.length > 0)
		tab.deleteRow(0);

	// Bus setzen
	var i = document.form_bus.bus.selectedIndex;
	var bus = document.form_bus.bus[i].value;
	switch (bus)
	{
		case "MBus":
			var busPath = top.mbus_path;
			break;
		case "System":
			var i = document.form_bus.subBus.selectedIndex;
			var busPath = document.form_bus.subBus[i].value;
			break;
	}

	// alert (bus);

	// JSON zusammenstellen fuer MBus-Kommando
	var actObject = new Object();
	// bus
	actObject.bus = busPath;
	// id	
	tele_id = top.calculateRandom (1, 10000);
	actObject.id = tele_id.toString();
	// br
	for (var i=0; i<3; i++)
	{
		if (document.form_baudrate.rBr[i].checked == true)
			var br = document.form_baudrate.rBr[i].value;
	}
	actObject.br = br;
	// secAdr
	actObject.secAdr = "0";
	// cmd
	actObject.command = "SLAVE_SEARCH";
	// param
	actObject.param = "0";

	var objStr = JSON2.stringify (actObject, null, 4);	// Object -> String

	// Daten zum EWIO senden (Telegramm Master -> Slave ausloesen)
	top.setDataExtended ("mbus", "mbus", objStr);

	// Empfangstelegramm(e) Slave -> Master lesen, Daten anfordern via mbus_response()
	mbus_timeout = setInterval ("top.getDataExtended ('mbus_'+tele_id, 'mbus', 'top.frame_content.mbus_response(actStr)')", 2000);

	// Such-Baudrate global speichern
	top.search_br = br + "";
	search_br = br + "";

}

// ********************************************************************************************

// Antworttelegramme  Slave -> Master
function mbus_response(actStr)
{

	if (DEBUG_DATA)	
		alert (actStr);

	if (actStr.indexOf('{') == -1)
	{	
		// keine Antwort vom EWIO
		top.hideMessageBox();

		// Message filtern		
		actStr = top.getMessage (actStr);

		// mbus_controller hat noch nicht geantwortet
		if (actStr == "WEBGATE ERROR - NO ANSWER")
			return;

		// andere webGate-Fehler: Beenden
		run_search = 0;
		cnt_old = 0;

		stopIntervalTime ();
		var search_state = document.getElementById("search_state");
		search_state.innerHTML = ins("mbus_add_searchOff");		// "Suche beendet"

		clearTimeout (mbus_timeout);

		// MBus-Empfangsfile auf dem Server loeschen
		setTimeout ("top.setDataExtended ('mbus', 'mbus_remove', '{\"id\":\"'+tele_id+'\"}')", 2000);		// Daten zum EWIO senden
		return;
	}


	// JSON-String in Objekt wandeln
	var jObject = JSON2.parse(actStr);
	

	// Tabelle
	var tr, td;
	var tbody = document.getElementById("tab_mbus_id");

	for (var i=0; i<1000; i++)
	{			   
		// aktuelle Suchadresse anzeigen = letzte Suchadresse in der Tabelle
		document.form_search_adr.searchAdr.value = jObject.progress;

		// Abbruch, wenn kein Eintrag mehr
		if (jObject.slaves[i] === undefined)
			break;	

		var cnt = parseInt(jObject.slaves[i].cnt);
		if (DEBUG_DATA)
			alert ("cnt = "+cnt);

		// neue Zeile wird eingefuegt, wenn cnt > 0 und cnt erhoeht wird;
		// in diesem Fall wurde eine neue ID erkannt
		if ((jObject.slaves[i].cnt > 0) && (jObject.slaves[i].cnt > cnt_old))
		{
			cnt_old = cnt;
			tr = tbody.insertRow(tbody.rows.length);		// neue Reihe

			// jede 2. Reihe andersfarbig ("Zebratabelle")
			if (tbody.rows.length % 2 == 0)	
				tr.setAttribute ("class", "row_color_odd");
			else
				tr.setAttribute ("class", "row_color_even");

			// 1. Spalte lfd.Nr.
			td = tr.insertCell(tr.cells.length);
			td.innerHTML = cnt;
			td.setAttribute ("class", "td_50");

			// 2. Spalte MBus-Id
			var mbus_id = jObject.slaves[i].sec_address;
			if (DEBUG_DATA)
				alert ("mbus_id = "+mbus_id);
			td = tr.insertCell(tr.cells.length);
			td.innerHTML = mbus_id;
			td.setAttribute ("class", "td_200");

			// 3. Spalte Primaer-Adr.
			var primAdr = jObject.slaves[i].prim_address;
			td = tr.insertCell(tr.cells.length);
			td.innerHTML = primAdr;
			td.setAttribute ("class", "td_100");

			// die letzten beiden Spalten werden in Abhaengigkeit von der
			// DB-Konfiguration gefuellt
			var match = 0;			
			for (var j=0; j<oConfig.counter.length; j++)
			{
				if (jObject.slaves[i].sec_address == oConfig.counter[j].BusAdr)
				{
					match = 1;
					break;					
				}
			}

			// 4. Spalte Konfig-Status 
			td = tr.insertCell(tr.cells.length);
			if (match)	
			{
				td.innerHTML = "config";
				td.style.color = "#00DF00";	
			}			
			else			
			{
				td.innerHTML = "no config";
				td.style.color = "#F80007";	
			}			
			td.setAttribute ("class", "td_100");

			// 5. Spalte Checkbox 
			td = tr.insertCell(tr.cells.length);
			if (!match)	
				td.innerHTML = '<input name="check_'+i+'" type="checkbox" checked="checked">';
			td.setAttribute ("class", "td_100");
			td.setAttribute ("style", "text-align:center;");

			// scrolle zur letzten eingefuegten Reihe
			var tElement   = tbody.getElementsByTagName("tbody")[0]; 
			var scroll_area = document.getElementById('scroll_1');
			scroll_area.scrollTop = tElement.clientHeight;
		}
	}

	// Suchende erreicht?
	if (jObject.state == "end")
	{		
		run_search = 0;
		cnt_old = 0;

		stopIntervalTime ();
		var search_state = document.getElementById("search_state");
		search_state.innerHTML = ins("mbus_add_searchOff");		// "Suche beendet"

		clearTimeout (mbus_timeout);

		// MBus-Empfangsfile auf dem Server loeschen
		setTimeout ("top.setDataExtended ('mbus', 'mbus_remove', '{\"id\":\"'+tele_id+'\"}')", 2000);		// Daten zum EWIO senden

		// Liste fertig, Button freigeben
		top.document.getElementById("button_1").disabled = false;
		top.document.getElementById("button_2").disabled = false;

		// Button "Suche abbrechen" disable
		document.form_search_activate.button.disabled = true;
	}

	// Objekt lokal fuer andere Funktionen speichern
	localObj = jObject;

}


// ********************************************************************************************

// SlaveSearch abbrechen
function breakSearch()
{
	run_search = 0;
	cnt_old = 0;
	clearTimeout (mbus_timeout);
	
	// Daten zum EWIO senden (Abbruch SlaveSearch ausloesen)
	// JSON zusammenstellen fuer MBus-Kommando: id = -1
	var objStr = '{"id": "-1"}';
	top.setDataExtended ("mbus", "mbus", objStr);
	
	// Anzeige
	stopIntervalTime ();
	var search_state = document.getElementById("search_state");
	search_state.innerHTML = ins("mbus_add_searchBreak");		// "Suche abgebrochen"

	// MBus-Empfangsfile auf dem Server loeschen
	setTimeout ("top.setDataExtended ('mbus', 'mbus_remove', '{\"id\":\"'+tele_id+'\"}')", 1500);		// Daten zum EWIO senden

	// Liste fertig, Button freigeben
	top.document.getElementById("button_1").disabled = false;
	top.document.getElementById("button_2").disabled = false;

	// Button "Suche abbrechen" disable
	document.form_search_activate.button.disabled = true;
}

// ********************************************************************************************
// ********************************************************************************************

// gefundene Zaehler in den Konfigurations-Abschnitt der Navigation einbauen
function mbus_addCounter()
{

	// Aufruf der Resetfunktion
	counterIndex = 0;

//	// ("Primaeradressen nicht benutzter Zaehler werden resettet.");
//	top.messageBox ("INFO", ins("mbus_add_mess_prim"));
	top.messageBox_Wait_ext (ins("mbus_add_mess_prim"));
	prim_timeout = setInterval ("resetCounter()", 1000);
}

// ********************************************************************************************

// Primaeradressen aller nicht konfigurierten Zaehler resetten
function resetCounter ()
{
	// BusPath ermitteln
	var i = document.form_bus.bus.selectedIndex;
	var search_bus = document.form_bus.bus[i].value;
	if (search_bus == "MBus")	
		var busPath = top.mbus_path;	
	else
	{
		var i = document.form_bus.subBus.selectedIndex;
		var busPath = document.form_bus.subBus[i].value;	
	}

	// Tabelle
	var tbody = document.getElementById("tab_mbus_id");
	for (var i=counterIndex; i<tbody.rows.length; i++)	
	{
		// alle Zaehler mit Status "no config" resetten
		if (tbody.rows[i].cells[3].innerHTML == "no config")
		{
			// nur wenn Primaeradresse noch nicht resettet ist
//			if ((tbody.rows[i].cells[2].innerHTML != "0") && (tbody.rows[i].cells[2].innerHTML != "253"))
			if (tbody.rows[i].cells[2].innerHTML != PRIM_RESET)
			{
				var mbus_id = tbody.rows[i].cells[1].innerHTML;
				// Messagebox
				top.hideMessageBox();
//				// ("Resette Primaeradresse von <br> <b>" + mbus_id + "</b>");
//				top.messageBox ("INFO", ins("mbus_add_mess_prim_of") + mbus_id + "</b>");
				top.messageBox_Wait_ext (ins("mbus_add_mess_prim_of") + mbus_id + "</b>");
				resetPrimaryAddress (busPath, mbus_id, search_br);
			
				counterIndex = i+1;		// naechster Zaehler
				break;		
			}		
		}	
	}

	// alle Zaehler durchlaufen
	if (i == tbody.rows.length) 
	{
		// Reset abschliessen
		clearTimeout (prim_timeout);

		// Messagebox schliessen
		top.hideMessageBox();


		// ----------------------------------------------------------------------------------------
		// tree aktualisieren
		var newTreeObj = mbus_setTreeData (top.frame_tree.treeDataObj);
		oStr = JSON2.stringify (newTreeObj, null, 0);	// Object -> String

		// neuen tree zum EWIO senden
		top.frame_tree.shadeTree (1);
		setTimeout ("top.setDataExtended ('/config/www/tree/treeData.js', 'fileload', oStr)", 1000);

		// Navigation refresh
		setTimeout ("top.frame_tree.tree_getData_mbusConfiguration(oStr)", 1000);

		// Button enabeln	
		top.document.getElementById("button_2").disabled = false;
	}
}

// ********************************************************************************************

// Antwort
function mbus_setTreeData (treeObj)
{

	// Bus und SubBus ermitteln
	var i = document.form_bus.bus.selectedIndex;
	var search_bus = document.form_bus.bus[i].value;
	if  (search_bus == "System")
	{
		var i = document.form_bus.subBus.selectedIndex;
		var search_subBus = document.form_bus.subBus[i].text;		
	}
	else
		var search_subBus = 0;		


	// Tabelle
	var tbody = document.getElementById("tab_mbus_id");

	// treeObj aktualisieren
	for (var i=0; i<tbody.rows.length; i++)	
	{
		// alle Zaehler mit Status "checked"
		var check = eval ('document.getElementsByName("check_'+i+'")');
		if ((check[0] !== undefined) && (check[0].checked))
		{
			// alert (check[0].name + "   " + check[0].checked);
			var mbus_id = tbody.rows[i].cells[1].innerHTML;
			
			// wenn der Eintrag schon existiert, dann nicht anlegen
			var match = 0;			
			for (var j=0; j<treeObj.MBus.configuration.counter.length; j++)	
			{
				if (treeObj.MBus.configuration.counter[j].info == mbus_id)
				{			
					match = 1;				
					break;	
				}			
			}
			if (match == 0)
			{
				var length = treeObj.MBus.configuration.counter.length;
				treeObj.MBus.configuration.counter[length] = new Object();
				treeObj.MBus.configuration.counter[length].icon = "tools_red.gif"; 
				treeObj.MBus.configuration.counter[length].text = mbus_id;
				treeObj.MBus.configuration.counter[length].info = mbus_id;
				treeObj.MBus.configuration.counter[length].info_1 = search_bus;
				treeObj.MBus.configuration.counter[length].info_2 = search_subBus;
				treeObj.MBus.configuration.counter[length].info_3 = search_br;
				treeObj.MBus.configuration.counter[length].target = "mbus_config.htm";
			}	
		}
	}

	// evtl. vorhandenen "no entry" entfernen, falls Zaehler gefunden wurden
	var length = treeObj.MBus.configuration.counter.length;
	if (length > 1)
	{	
		if (treeObj.MBus.configuration.counter[0].text == "no entry")
		{
			// Eintrag "no entry" entfernen					
			treeObj.MBus.configuration.counter.splice(0, 1);				
		}
	}

	return treeObj;
}

// ********************************************************************************************
// Hinzufuegen eines Eintrags innerhalb der Select-Box
function addSelectOption (parent, value, text)
{
	// Element erzeugen
	var newdiv = document.createElement("option");
	newdiv.setAttribute("value", value);	

	// Textinhalt		
	var textNode = document.createTextNode (text);
	newdiv.appendChild (textNode);

	// Element in SelectBox einfuegen
	parent.appendChild (newdiv);
}

// ********************************************************************************************
// Periodisch eine Funktion ausfuehren
// t_function = Funktion
// time = Zeit in ms

var intervall_id = 0;
function setIntervalTime(t_function, time)
{
	if (intervall_id != 0)
		clearInterval (intervall_id);	

	intervall_id = setInterval (t_function, time);
}

// ********************************************************************************************
// Timer unterbrechen
function stopIntervalTime ()
{
	clearInterval (intervall_id);	
}

// ********************************************************************************************
// Text ein- und ausblenden
function toggleText ()
{
	var search_state = document.getElementById("search_state");
	if (search_state.innerHTML == "")
		search_state.innerHTML = ins("mbus_add_searchOn"); 		// "Suche laeuft"
	else
		search_state.innerHTML = "";
}

// ********************************************************************************************
// ********************************************************************************************

// Eine Zelle in der Tabelle setzen
function setTableElement (table_id, row, cell, value)
{
	var parent = document.getElementById (table_id);
	parent.rows[row].cells[cell].innerHTML = value;
}

// ********************************************************************************************

// Eine Zelle in der Tabelle lesen
function getTableElement (table_id, row, cell)
{
	var table = document.getElementById (table_id);
	var result = table.rows[row].cells[cell].innerHTML;
	return (result);
}

// ********************************************************************************************
// ********************************************************************************************

// Primaeradresse ruecksetzen
function resetPrimaryAddress (bus, mbus_id, br)
{
	var actObject = new Object();

	actObject.bus = bus+"";
	actObject.id = "0";
	actObject.br = br+"";								// Baudrate, auf welcher gesendet wird
	actObject.secAdr = mbus_id;
	actObject.command = "RESET_PRIMARY_ADDRESS";
	actObject.param = "0";							 

	var actStr = JSON2.stringify (actObject, null, 4);	// Object -> String
	top.setDataExtended ("mbus", "mbus", actStr);		// Daten zum EWIO senden (Telegramm Master->Slave)

}

// ********************************************************************************************





// ********************************************************************************************
// ********************************************************************************************

// INFO
// counter

function info_bus()
{
	var headline =  '<B>INFO: BUS </B>';
	content =		'<div class="pos x0101 textfield"> '+ins("mbus_add_info_bus")+
					'</div>' +

					'<div id="button_position">'+
					'<input type="button" class="single_button_ok" name="ok" value="OK" onClick="info_close()">'+
					'</div>';
	
	guiPopup.Show ("info", headline, content, 'Info', 500, 160, "window");
}

// ********************************************************************************************

// INFO schliessen
function info_close()
{

	// pad schliessen
	guiPopup.CloseMe("info");
}

// ********************************************************************************************
// ********************************************************************************************



