/**********************************************************************************************

	JS functions for displaying properties

	Copyright (c) 2013 MCQ TECH GmbH (rstiawa@metz-connect.com)
	Version 1.0	  03/2013

***********************************************************************************************/



// ********************************************************************************************
/*
	Werte aendern:
	wird ein Feld geaendert (text, select o..) wird bei jeder Aenderung der neue Wert in der 
	JSON-Instanz gespeichert.
	Will man die ursprnglichen Werte wiederhaben => JSON-Instanz neu laden
	Will man die Aenderungen dauerhaft speichern => JSON-Instanz senden
	
	In der ID wird der Pfad fuer die Property codiert:
	id_CableEnd/RFID
	Zugriff auf die geaenderte Property mittels this.id
	Der geaenderte Wert wird geschrieben, indem der aus der div id decodierte path zum Schreiben
	verwendet wird.
	
	Speichern:
	JSON-Instanz senden

	Beachten: Das event zum Speichern des geaenderten Werts wird nur ausgeloest, wenn alle Elemente
	ohne "innerHTML" erzeugt wurden! (Sondern "createElement() usw.)
*/

// ********************************************************************************************

// expandiertes schema als lokale Variable speichern
var schemaExpanded = {};

// letzte Parameter fuer den Aufbau des content
var content = {};


// ********************************************************************************************
// Content aufbereiten
// ********************************************************************************************

// content bereitstellen
function setContent (key, value, type, path)
{
	module = "content";

	// content loeschen
	document.getElementById("content").innerHTML = "";

	// content fuellen
	setValues (key, value, type, path);

	// Parameter merken
	content.key = key;
	content.value = value;
	content.type = type;
	content.path = path;
}

// ********************************************************************************************
// Value durch den Pfad ermitteln (Quelle = JSON-Instanz)
// Pfad darf nicht leer sein (muss mindestens ein Element enthalten!, hier z.B. "RCU")
function setValues (key, value, type, path)
{
	var obj = json_instance;

	var pathArr = path.split(",");
	// alert ("Parameter Pfad: " + pathArr);		// Array mit []	

	// wenn Pfad PCUPorts enthaelt, diese ueberspringen
	if (path.indexOf("PCUPorts") != -1)
		return; 

	// wenn Pfad Logs enthaelt, diese ueberspringen
	if (path.indexOf("Logs") != -1)
		return; 


	// Ausgabe des Objekts
	outputDir (type, pathArr);

	// Ermitteln des Values
	for (var i=0; i<pathArr.length; i++)
	{
		// Arrays werden immer mit [] geklammert, 
		// Klammern muessen fuer Objektaufloesung entfern werden
		if (pathArr[i].charAt(0) == '[')				// innerhalb eines arrays
			obj = obj[pathArr[i].slice(1,-1)];			// [] entfernen
		else if (obj[pathArr[i]] == undefined)
		{
			// Fehler 
			alert ("setValues error path: pos "+ parseInt(i+1) +"   "+pathArr[i]);	
			alert ("Pfad: " + pathArr);		
			alert (JSON.stringify (obj, null, 4));
			return;
		}
		else 											// objekt
			obj = obj[pathArr[i]];
	}
	
	if ((type == "obj") || (type == "arr"))
	{
		// alert (JSON.stringify (obj, null, 4));
		for (var prop in obj)
		{
			if (obj[0])		var property = "[" + prop + "]";
			else			var property = prop;
			// alert (JSON.stringify (obj[prop], null, 4));
			// alert (pathArr.toString()+"   "+prop);

			switch (typeof(obj[prop]))
			{
				case "object":		
					//document.getElementById("content").innerHTML += "obj<br>";
					pathArr[pathArr.length] = property;
					path = pathArr.toString();
					// alert (path);
							
					// weiteres Objekt, rekursiver Aufruf
					setValues (key, value, type, path);
					pathArr.length--;
					break;
					
				default:
					// wenn property = PortMask, diese ueberspringen
					if (property == "PortMask")
						return; 

					value = obj[prop];

					// Den Pfad fuer die Ausgabe vervollstaendigen
					path = pathArr.toString();
					var out_path = path+","+property;
					//alert ("1:" + prop + "   " + value + "   " + out_path);
						
					// Ausgabe Values
					outputValues (prop, value, out_path);

					// Beschreiber (aus JSON Schema) hinzufuegen, Pfad aus Objekten ermittelt
					setProperties (out_path);
					break;
			}
		}
	}
	else
	{
		// Ausgabe Values
		 alert ("2:" + prop + "   " + value + "   " + out_path);
		outputValues (key, obj, path);

		// Beschreiber (aus JSON Schema) hinzufuegen, Pfad aus Parameter
		setProperties (path);	
	}	

	// alert (document.getElementById("content").innerHTML);	
}

// ********************************************************************************************
// Beschreiber durch den Pfad ermitteln (Quelle = JSON Schema)
function setProperties (path)
{
	// Pfad zum angebenenen Objekt ermitteln
	var pathArr = path.split(",");
	// alert ("Pfad: " + pathArr);
	
	var obj = schemaExpanded.properties; 
	// alert (JSON.stringify (obj, null, 4));
	
	var valid = true;
	for (var i=0; i<pathArr.length; i++)
	{
		if (obj == undefined)
		{
			alert ("undefined object: \n" + pathArr[i]);
			return;
		}
		else if (pathArr[i].charAt(0) == '[')							// innerhalb eines arrays
		{
			//alert ("element "+i+" = " + JSON.stringify (obj[pathArr[i]], null, 4));
	
			// pruefen, ob Array properties enthaelt;
			// wenn nicht, dann enthaelt es einfache Strings, Zahlen oder Boolsche Werte
			if (obj["properties"] != undefined)
				obj = obj["properties"];
		}
		else if (obj[pathArr[i]] == undefined)
		{
			// zum angefragten Element der Instanz gibt es keinen Eintrag im Schema
			alert ("No schema entry for property: \n" + pathArr[i]);
			// alert (JSON.stringify (obj, null, 4));
			return;
		}
		else if (obj[pathArr[i]]["items"] != undefined)				// array
			obj = obj[pathArr[i]]["items"];
		else if (obj[pathArr[i]]["properties"] != undefined)		// objekt
			obj = obj[pathArr[i]]["properties"];
		else if (obj[pathArr[i]] != undefined)						// objekt ohne properties
			obj = obj[pathArr[i]];
		else
		{
			valid = false;
			alert ("false: "+ JSON.stringify (obj, null, 4));
			break;
		}

		// alert (JSON.stringify (obj, null, 4));
	}

	// Objekt im Schema gefunden
	if (valid == true)
	{
		// alert (JSON.stringify (obj, null, 4));

		// Ausgabe Properties
		outputProperties (obj, path);
	}
}

// ********************************************************************************************
// Inhalt Content loeschen
function contentHide()
{
	// content loeschen
	document.getElementById("content").innerHTML = "";
}

// ********************************************************************************************
// ********************************************************************************************














// ********************************************************************************************
// Schema expandieren
// ********************************************************************************************
// Schema mit $ref-Objekten expandieren
function expandSchema (oAll, oPart)
{
	// durch das gesamte Objekt hangeln und rekursiv alle Elemente ermitteln
	for (var prop in oPart) 
	{
		if (typeof(oPart[prop]) == "object") 
		{
			if (oPart[prop].$ref != undefined)
			{
				// Objekt mit $ref gefunden
				// alert ("Objekt mit property $ref: " + prop);
				
				// die verschiedenen Objektebenen werden in einem Array zusammengestellt ([]);
				// dieses wird bei jedem Wechsel der Ebene aktualisiert;
				// dadurch kann der Ort eines gefundenen Objekts ermittelt werden
				
				// Inhalt des Objekts austauschen
				var oReplace = getObject_draft3 (oAll, oAll, oPart[prop].$ref, []);
				if (oReplace == undefined)
					alert ("kein Replace-Objekt zu " + oPart[prop].$ref + " gefunden");
				else
				{
					// Aufrufer retten
					var oldPart = oPart[prop];		

					// beide Objekte voneienander unabhaengig machen, sonst wirkt sich eine Aenderung in beiden Objekten aus,
					// (also nicht: oPart[prop] = oReplace;)
					var newPart = JSON.parse( JSON.stringify(oReplace ) );		// Referenz
				
					// id entfernen, falls vorhanden
					// (id wird nur vom Aufrufer uebernommen, falls dieser eine hat)
					if (newPart.id != undefined)
						delete newPart.id;
				
					// Referenz wird in Aufrufer eingesetzt
					// Elemente des Aufrufers haben Vorrang vor denen der Referenz:
					// - Elemente, die nur im Aufrufer vorhanden sind, aber nicht in der Referenz, werden dort eingefuegt
					// - Elemente, die im Aufrufer und in der Referenz vorhanden sind, werden vom Aufrufer uebernommen	
					for (var prop1 in oldPart)
					{
						if (prop1 == "$ref")	// property "$ref" nicht kopieren	
							continue;
						newPart[prop1] = oldPart[prop1];
					}
					oPart[prop] = newPart;
				}
			}
		
			// innerhalb eines Objektes rekursiv weitersuchen
			expandSchema (oAll, oPart[prop]);		
		}
	}
	return oPart;
}

// ********************************************************************************************
// Objekt suchen, das durch das element bezeichnet wird;
// es werden nur Objekte in der Wurzel gesucht (schema draft1, draft2)
function getObject (obj, element)
{
	// Element aus dem String der Form #.element extrahieren
	var elArr = element.split (".");
	
	// Element im Objekt suchen	
	for (var prop in obj) 
	{
		if (typeof(obj[prop]) == "object") 
		{
			// alert ("prop = " + prop + "\nelement = " + elArr[1]);
			if (prop == elArr[1])
			{
				return (obj[prop]);
			}
		}
	}
}

// ********************************************************************************************
// Objekt suchen, das durch das element bezeichnet wird
// Algorithmus fuer schema draft3
function getObject_draft3 (oAll, obj, element, path)
{
	// Element aus dem String der Form "$Element" extrahieren
	if (element.charAt(0) == "$")	
		element = element.substring (1);


	// Return-Objekt initialisieren
	var oRet = {};

	// Objekt durchlaufen
	for (var prop in obj)
	{
		if (typeof(obj[prop]) == "object")
		{
			// if ((prop == "Approval") && (element == "Approval"))
			//  alert ("prop = "+ prop + "\nelement = " + element + "\npath = " + path);

			// pruefen, ob es zu diesem objekt eine "id"-property gibt 
			if (obj[prop]["id"] != undefined)
			{
				// wenn der Inhalt der id = element ist, dann haben wir die Referenz gefunden
				if (obj[prop]["id"] == element)
				{
					// if ((prop == "Approval") && (element == "Approval"))
					//	 alert ("found = " + element + "\npath = " +  path);
				
					// element als letztes Pfadelement hinzufuegen
					path[path.length] = element;
					
					// Objekt ermitteln
					oRet = selectObject (oAll, path);
					return oRet;
				}
			}
			
			// rekursiver Aufruf
			path[path.length] = prop;
			oRet = getObject_draft3(oAll, obj[prop], element, path);
			path.length--;

			// wenn das Objekt mit Propperties gefuellt ist, wurde das Element gefunden
			if (getObjectLength (oRet))		
				return oRet;	
		}
	}
	return oRet;
}

// ********************************************************************************************
/*
	obj ist das Gesamt-Objekt
	pathArr ist ein Array, welches die einzelnen verschachtelten Objekte wie einen Pfad enthaelt
	Die Funktion gibt ein Objekt mit dem enthaltenen Pfad zurueck
	
	Beispiel:
	obj = schema
	pathArr = properties, Log, items, properties, Row
	return = schema["properties"]["Log"]["items"]["properties"]["Row"] 
	
*/
function selectObject (obj, pathArr)
{ 
	// alert (pathArr);

	for (var i=0; i<pathArr.length; i++)
	{
		// fuer die Zuordnung der Inline-Referenzen mus das fuehrende "#" entfernt werden
		if (pathArr[i].charAt(0) == "#")	
			pathArr[i] = pathArr[i].substring (1);

		// Arrays werden immer mit [] geklammert, 
		// Klammern muessen fuer Objektaufloesung entfern werden
		if (pathArr[i].charAt(0) == '[')				// innerhalb eines arrays
			obj = obj[pathArr[i].slice(1,-1)];			// [] entfernen
		else if (obj[pathArr[i]] == undefined)
		{
			// Fehler 
			alert ("selectObject error path: pos "+ parseInt(i+1) +"   "+pathArr[i]);	
			alert ("Pfad: " + pathArr);		
			alert (JSON.stringify (obj, null, 4));
			return;
		}
		else 											// objekt
			obj = obj[pathArr[i]];
	}
	
	// alert (JSON.stringify (obj, null, 4));
	return obj;
}

// ********************************************************************************************
// Anzahl der Elemente in einem Objekt zaehlen
function getObjectLength (obj)
{
	var i = 0;
	for (var prop in obj) 
		i++;	

	// alert ("anz properties = " + i);
	return i;
}

// ********************************************************************************************
// ********************************************************************************************











// ********************************************************************************************
// Output
// ********************************************************************************************

// Ausgabe des Objektbezeichners
function outputDir (type, pathArr)
{
	// alert ("outputDir type = " + type + "\npath = "+ pathArr);
	
	// Ausgabe path (Text-Element)
	var path = pathArr.toString();

	if ((type == "obj") || (type == "arr"))		var length = pathArr.length;
	else										var length = pathArr.length - 1;

	// kein Bezeichner innerhalb von Arrays aus Objekten
	if (pathArr[pathArr.length - 1].indexOf("[") != -1) 
		return;

	// <br>
	dom_add_htmlElement ('content', 'br');


/*
	// Variante: Darstellung des gesamten Pfad
	var style = "position:relative; left:0px; background-color:#D6D3D6; border:0px; font-weight:bold;";
	for (var i=0; i<length; i++)
	{
		dom_add_text ("content", pathArr[i], "textfield", style);
		if (i<length-1)
			dom_add_text ("content", " / ", "textfield", style);
	}
*/

	// Variante: letzten Bezeichner vom Pfad ausgeben 
	//offset = 20 * (pathArr.length - 1);		// entsprechend Position einruecken
	offset = 0;	
	var style = "position:relative; left:"+offset+"px; background-color:#D6D3D6; border:0px; font-weight:bold;";
	dom_add_text ("content", pathArr[pathArr.length - 1], "textfield", style);


	// alert (document.getElementById("content").innerHTML);	
}

// ********************************************************************************************
// Anlegen des DIV und Ausgabe des Values
function outputValues (key, value, path)
{
	// alert ("VALUE " + path);

	// key/value innerhalb eines Arrays ?
	var pathArr = path.split(",");
	if (pathArr[pathArr.length - 2].indexOf("[") != -1) 
	{					
		outputValuesInArray (key, value, path);
		return;		
	}

	// DIV erzeugen
	var id_div = makeIdFromPath ("div_", path)
	dom_addElement_div ("content", id_div, "value"); 
	
	// Ausgabe key (Text-Element)
	var style = "position:relative; left:0px; background-color:#D6D3D6; border-width:0px;";
	dom_add_text (id_div, key+": ", "textfield", style);
	
	// Ausgabe value (Input-Element text)
	var id_inp = makeIdFromPath ("inp_", path)
	var style = "position:relative; left:10px; width:50px; background-color:#FFFFFF; border-width:1px;";

	// Passwort: wenn nicht admin, dann Passwoerter verstecken
	if ((g_username != "Administrator") && (key == "p"))
		value = "********";

	dom_addElement_inp (id_div, id_inp, "text", value, "textfield", style);

	// Filter fuer Sonderformate
	if (key == "desc")
		document.getElementById(id_inp).style.width = "400px";		

	// Passwort: wenn nicht admin, dann Passwoerter als readonly
	if ((g_username != "Administrator") && (key == "p"))
		document.getElementById(id_inp).setAttribute ("readonly", "readonly");

	// Leerzeile zum folgenden Element
	// <br>
	dom_add_htmlElement ('content', 'br');

	// alert (document.getElementById("content").innerHTML);	
}

// ********************************************************************************************
// Ausgabe mehrerer key/values gruppiert innerhalb eines Array
function outputValuesInArray (key, value, path)
{
	// Eintrag in Tabelle
	// alert ("key="+key+"   value="+value+"   path="+path);

	var pathArr = path.split(",");					// zB device,TX,[0],function
	var path_1 = pathArr[pathArr.length - 2];		// zB [0]
	var path_2 = pathArr[pathArr.length - 3];		// zB TX

	// alert ("path="+path+"   path_1="+path_1+"   path_2="+path_2);

	// Reihe fuer aktuellen Wert ermitteln
	var index_row = parseInt(path_1.substring(1));
	// alert ("row = " + index_row);

	// IDs erzeugen
	var id_div = makeIdFromPath ("div_", path_2)
	var id_tab = makeIdFromPath ("tab_", path_2)
	var id_row = id_tab + "_" + index_row;

	// DIV erzeugen oder bereits vorhanden?
	if (document.getElementById(id_div) == undefined)
	{
		// alert ("DIV erzeugen: " + path_2);
		dom_addElement_div ("content", id_div, "valueInArr"); 

		// Tabellenkopf, minimal
		addElement_tab (id_div, id_tab, 0, 1, "tab_head");
		setTableElement (id_tab, 0, 0, key);	
	}
	else
	{
		// alert ("DIV vorhanden: " + path_2);
		if (index_row == 0)
		{
			// neue Spalte in der aktuellen Reihe anlegen und fuellen
			addTableCell (id_tab + "_head", 0, key, "tab_head", "width:100px");
		}	
	}	

	// neue Reihe ohne Spalten anlegen
	if (document.getElementById (id_tab).rows[index_row + 1] == undefined)	
		addTableRow_0 (id_tab, id_row);

	// jede 2. Reihe andersfarbig ("Zebratabelle")
	var tbody = document.getElementById(id_tab);
	var tr = document.getElementById(id_row);
	if (tbody.rows.length % 2 == 0)	
		tr.setAttribute ("class", "row_color_odd");
	else
		tr.setAttribute ("class", "row_color_even");

	// neue Spalte in der aktuellen Reihe anlegen und fuellen
	var id_cell = id_row + "_" + tr.cells.length;
	// alert (id_cell);
	addTableCell (id_row, id_cell, value, "tab_cell", "width:100px;");
}

// ********************************************************************************************
// Ausgabe der Properties aus dem Schema
function outputProperties (obj, path)
{
	// alert ("PROP " + path);
	
	// key/value innerhalb eines Arrays ?
	var pathArr = path.split(",");
	if (pathArr[pathArr.length - 2].indexOf("[") != -1) 
	{					
		outputPropertiesInArr (obj, path);
		return;
	}

	// ID fuer das Ziel-DIV ermitteln
	var id_div = makeIdFromPath ("div_", path)

	if (obj == undefined)
		return;

	// Ausgabe Formatanweisungen (Text-Element)
	var formatStr = "";

	// Ausgabe select oder Formatanweisungen
	if (obj.enum != undefined)
	{
		// Ausgabe select
		// Die select-Box wird ber die input-Textzeile gelegt, die input-Textzeile wird ausgeblendet;
		// Damit bleibt die Abfrage der Daten ber die input-Textzeilen erhalten.
		var id_sel = makeIdFromPath ("sel_", path)

		// select einfuegen
		var style = "position:absolute; left:100px; top: 10px; width:400px; background-color:#FFFFFF;";
		dom_addElement_select (id_div, id_sel, 1, "textfield", style);

		var selArray = obj.enum; 
		for (var i=0; i<selArray.length; i++)
			dom_addSelectOption (id_sel, selArray[i], selArray[i]);
	
		// input ausblenden
		var id_inp = makeIdFromPath ("inp_", path);
		document.getElementById(id_inp).style.visibility = "hidden";

		// option einstellen, welche dem gesetzten input entspricht
		 var id_inp = makeIdFromPath ("inp_", path);
		 var inpVal = parseInt(document.getElementById(id_inp).value);
		 for (var i=0; i<document.getElementById(id_sel).length; i++)
		 {
			if (document.getElementById(id_sel)[i].value == inpVal)
			{
				document.getElementById(id_sel).selectedIndex = i;	
				// alert (inpVal);				
			}
		}	

		// select als readonly
		if (obj.readonly != undefined)
		{
			document.getElementById(id_sel).disabled=true;

			if (formatStr.length)	formatStr += ", ";	
			formatStr += "read only";

			// input readonly setzen
			var id_inp = makeIdFromPath ("inp_", path)
			document.getElementById(id_inp).readOnly = true;

			var style = "position:absolute; left:550px; width:100px; background-color:#D6D3D6; border:0px";
			dom_add_text (id_div, formatStr, "textfield", style);
		}

		//alert (document.getElementById(id_div).innerHTML);
	}
	else
	{
		// minLength, maxLength
		if ((obj.minLength != undefined) && (obj.maxLength != undefined))
		{
			// min. = max.
			if (obj.minLength == obj.maxLength)
				formatStr += "length = " + obj.minLength;	
		}
		else
		{
			// min. und max. verschieden
			if (obj.minLength != undefined)
				formatStr += "min. length = " + obj.minLength;
			if (obj.maxLength != undefined)
			{
				if (formatStr.length)	formatStr += ", ";	
				formatStr += "max. length = " + obj.maxLength;
			}
		}			

		// input Laenge setzen
		if (formatStr.length)
		{
			var id_inp = makeIdFromPath ("inp_", path);
			document.getElementById(id_inp).maxLength = parseInt(obj.maxLength) + 25;	// ??? +25 ?
			if (obj.maxLength > 40)
				document.getElementById(id_inp).size = 40;
			else
				document.getElementById(id_inp).size = parseInt(obj.maxLength);
		}

		// readonly
		if (obj.readonly != undefined)
		{
			if (formatStr.length)	formatStr += ", ";	
			formatStr += "read only";

			// input readonly setzen
			var id_inp = makeIdFromPath ("inp_", path)
			document.getElementById(id_inp).readOnly = true;
		}

		// minimmum, maximum (Wertebereich fuer Integer)
		if ((obj.minimum != undefined) || (obj.maximum != undefined))
		{
			if (obj.minimum != undefined)		
			{
				if (formatStr.length)	formatStr += ", ";	
				formatStr += " value min. = ";
				formatStr += obj.minimum;
			}

			if (obj.maximum != undefined)		
			{
				if (formatStr.length)	formatStr += ", ";	
				formatStr += " value max. = ";
				formatStr += obj.maximum;
			}
		}

		if (obj.pattern != undefined)
		{
			// Anzeige der Pattern
			var id_inp = makeIdFromPath ("inp_", path);
			if (formatStr.length)	formatStr += ", ";	
			formatStr += top.showPattern (document.getElementById(id_inp).value, obj.pattern);

			// Auswertung der Eingabe
			document.getElementById(id_inp).setAttribute("pattern", obj.pattern);
		}

		// Ausgabe formatString
		var style = "position:relative; left:50px; width:300px; background-color:#D6D3D6; border-width:0px;";
		dom_add_text (id_div, formatStr, "textfield", style);


	
		// wenn format angegeben ist, dann Sonderformate
		if (obj.format != undefined)
		{
			var formatArr = obj.format.split(",");

			// checkbox
			if (formatArr[0] == "checkbox")
			{
				var id_chk = makeIdFromPath ("chk_", path);		
				var style = "position:relative; left:250px;";
				dom_addCheckbox (id_div, id_chk, "textfield", style, "false", eval(formatArr[2]));

				var style = "position:relative; left:250px; width:20px; background-color:#D6D3D6; border:0px";
				dom_add_text (id_div, formatArr[1], "textfield", style);	
			}

			// binary
			if (formatArr[0] == "binary")
			{
				// binary: Ausgabe Checkboxen (z.B. "format":"binary,4")
				// Eingegbenen Wert binaer aufspalten, um die relevanten Checkboxen zu setzen
				var id_inp = makeIdFromPath ("inp_", path)
				document.getElementById(id_inp).style.width = "100px";

				var binInput = parseInt(document.getElementById(id_inp).value);
				var binInputStr = binInput.toString(2);							// dezimal -> binaer
				binInputStr = addLeadingZeros (binInputStr, formatArr[1]);		// fuehrende Nullen einfuegen
				var binInputArr = binInputStr.split("");

				// alert (document.getElementById(id_inp).value + "   " + binInputArr);		

				for (var i=0; i<formatArr[1]; i++)
				{
					// binaerStufen berechnen
					var binVal = Math.pow(2, i);				
				
					// Checkbox aktiv setzen, wenn binaerWert = 1
					var check = false;
					if (binInputArr[formatArr[1] - i - 1] == 1) 
						check = true;
			
					// Ausgabe Checkboxen 
					if (i <=9 )		var id_chk = makeIdFromPath ("c0"+i+"_", path);		// Beispiel c01_...
					else			var id_chk = makeIdFromPath ("c"+i+"_", path);		// Beispiel c11_...		
					var style = "position:relative; left:80px;";
					dom_addCheckboxBin (id_div, id_chk, "textfield", style, check, binVal);

					var style = "position:relative; left:80px; width:20px; background-color:#D6D3D6; border:0px";
					dom_add_text (id_div, binVal, "textfield", style);	
				}		

			// alert (document.getElementById(id_div).innerHTML);	
			}

			// button
			// [0] = Sonderformat Button, [1] = Beschriftung Button, [2] = Funktionsname
			if (formatArr[0] == "button")
			{
				// Button 
				var id_but = makeIdFromPath ("but_", path)

				// Button einfuegen
				var style = "position:absolute; left:520px;";
				dom_addElement_button (id_div, id_but, formatArr[1], "textfield", style, eval(formatArr[2]));	
			}
		
			// visibility, Sichtbarkeit steuern 
			// [0] = Sonderformat visibilty, [1] = Bedeutung value, [2] = Pfad des steuernden values
			if (formatArr[0] == "visibility")
			{
				// value (true/false) von dem Eintrag suchen, der als Parameter angegeben ist
				var obj_vis = json_instance;	
				var path_vis = 	formatArr[2].replace(/\//g, ",");
				var pathArr = path_vis.split(",");
				for (var i=0; i<pathArr.length-1; i++)
				{
					if (pathArr[i].charAt(0) == '[')				// innerhalb eines arrays
						obj_vis = obj_vis[pathArr[i].slice(1,-1)];			// [] entfernen
					else
						obj_vis = obj_vis[pathArr[i]];
				}		
		
				// alert (obj_vis[pathArr[pathArr.length-1]]+ "   " + typeof(obj_vis[pathArr[pathArr.length-1]]));
				// alert(formatArr[1] + "   " + typeof(formatArr[1]));

				// in Anhaengigkeit vom ermittelten value den aktuellen value abschatten oder nicht
				// Anm.: das obj_vis ist boolean (aus json-instanz), das formatArr[1] ein string aus dem schema
				if ((obj_vis[pathArr[pathArr.length-1]] == false) && (formatArr[1] == "true") ||
					(obj_vis[pathArr[pathArr.length-1]] == true) && (formatArr[1] == "false"))
				{
					var id_inp = makeIdFromPath ("inp_", path);
					document.getElementById(id_inp).style.background = "#D6D3D6"; 	//"#E6E3E6";
					document.getElementById(id_inp).setAttribute("readonly", "true");
				}
			}

			if (formatArr[0] == "width") 
			{
				// Laenge des input-Fensters festlegen
				var id_inp = makeIdFromPath ("inp_", path);
				document.getElementById(id_inp).style.width = formatArr[1];	
			}

			// HTML 5.0	
			if (formatArr[0] == "uri") 
			{
				// es werden nur Namen akzeptiert (z.B. http:// ...), keine Adressen
				// var id_inp = makeIdFromPath ("inp_", path);
				// document.getElementById(id_inp).setAttribute("type", "url");

			}
			if (formatArr[0] == "email") 
			{
				var id_inp = makeIdFromPath ("inp_", path);
				document.getElementById(id_inp).setAttribute("type", "email");
			}
		}
	

		// Boolean, Auswahl-Checkbox einfuegen
		if (obj.type != undefined)
		{
			if (obj.type == "boolean")
			{
				var id_inp = makeIdFromPath ("inp_", path);
				var value = document.getElementById(id_inp).value;		// "true" / "false"

				// ID CheckBox
				var id_checkbox = makeIdFromPath ("chb_", path)

				// CheckBox einfuegen
				var style = "position:relative; left:80px;";
				dom_addCheckboxBool (id_div, id_checkbox, "textfield", style, value);

				var style = "position:relative; left:90px; width:20px; background-color:#D6D3D6; border:0px";
				dom_add_text (id_div, "true / false", "textfield", style);	
		
				// Wert soll nur ber Checkbox geaendert werden koennen
				document.getElementById(id_inp).setAttribute("readonly", "true");

				// readonly ?
				if (obj.readonly != undefined)
					document.getElementById(id_checkbox).disabled = "disabled";
			}			
		}	
	}

	// Ausgabe Description
	if (obj.description != undefined)
	{
		var id_dsc = makeIdFromPath ("dsc_", path)
		dom_addElement_textarea (id_div, id_dsc, "description", obj.description); 
	}
	else
	{
		// <br>
		dom_add_htmlElement (id_div, 'br');
		dom_add_htmlElement (id_div, 'br');
	}

	// alert (document.getElementById("content").innerHTML);	
 	// alert (document.getElementById(id_div).innerHTML);	
}

// ********************************************************************************************
// Ausgabe der Properties aus dem Schema fuer Gruppierung im Array
function outputPropertiesInArr (obj, path)
{

	if (obj == undefined)
		return;
	// alert (JSON.stringify (obj, null, 4));

	var pathArr = path.split(",");
	var path_1 = pathArr[pathArr.length - 2];
	var path_2 = pathArr[pathArr.length - 3];

	var id_div = makeIdFromPath ("div_", path_2)
	var id_tab = makeIdFromPath ("tab_", path_2)

	// Reihe fuer aktuellen Wert ermitteln
	var index_row = parseInt(path_1.substring(1));

	// Ausgabe Formatanweisungen (Text-Element)
	var formatStr = "";

	// ID Reihe
	var id_row = id_tab + "_" + index_row;

	// ID Zelle
	var tableRow = document.getElementById(id_row);
	var cellLength = tableRow.cells.length - 1;
	var id_cell = id_row + "_" +  cellLength;


	// wenn format angegeben ist, dann Sonderformate
	if (obj.format != undefined)
	{
		var formatArr = obj.format.split(",");

		// checkbox
		if (formatArr[0] == "checkbox")
		{
			//	alert (index_row);

			// Checkbox setzen
			var id_chk = makeIdFromPath ("chk_", path);		
			dom_addCheckbox (id_cell, id_chk, "textfield", "", "false", eval(formatArr[2]));
		}

		// Spaltenbreite
		if (formatArr[0] == "cell_width")
		{
			var lastCell = tableRow.cells[cellLength];
			// dumpObject(lastCell); 
			lastCell.style.width = formatArr[1];
		}
	}
	// alert (document.getElementById("content").innerHTML);	
}


// ********************************************************************************************
// ********************************************************************************************











// ********************************************************************************************
// EVENTS
// ********************************************************************************************

// Geaenderte Werte speichern
function setChangedValue (element)
{
	// Pfad aus ID ermitteln
	var path = makePathFromId (element.id);
	var pathArr = path.split(",");


	// Pruefen, ob die Eingabe gueltig ist (HTML5)
	// (false, wenn eine Pruefung durch das input-Element eine fehlerhafte Eingabe feststellt)	
	// alert (element.checkValidity());		
	if (element.checkValidity() == false)
	{
		messageBox ("INPUT - " + pathArr.toString(), "Eingabe entspricht nicht den Vorgaben!");
		return;
	}

	
	// Objekt bauen
	if (module == "content")
		obj = json_instance;	
	else if (module == "ports")	
	{
		obj = portData;	
		portChange = 1;		// Flag fuer Konfig-Aenderung setzen	
	}

	for (var i=0; i<pathArr.length-1; i++)
	{
		if (pathArr[i].charAt(0) == '[')				// innerhalb eines arrays
			obj = obj[pathArr[i].slice(1,-1)];			// [] entfernen
		else
			obj = obj[pathArr[i]];
	}

	// das zu setzende Element soll von der gleichen Art sein, wie das bestehende
	// (also int, string oder bool)
	// alert (typeof obj[pathArr[pathArr.length-1]]);	
	var value = element.value;									// string, default
	if (typeof obj[pathArr[pathArr.length-1]] === "number")
		value = parseInt(element.value);						// number

	if (typeof obj[pathArr[pathArr.length-1]] === "boolean")	// boolean
	{
		if (element.value == "true")		value = true;
		else								value = false;
	}

	obj[pathArr[pathArr.length-1]] = value;

	// alert (JSON.stringify (obj, null, 4));	
	// alert (JSON.stringify (json_instance, null, 4));
	// document.write(JSON.stringify (obj, null, 4));	
}


// ********************************************************************************************

// Setzen select value
function content_setSelectValue (element)
{
	// Value soll nicht am select-Element geaendert werden, sondern der Value selbst
	var path = makePathFromId (element.id);
	var id_inp = makeIdFromPath ("inp_", path)
	element.id = id_inp;
	//alert (element.value);
	//alert (element.id);

	// value Anzeige aktualisieren
	document.getElementById(id_inp).value = element.value;

	// JSON-Instanz aktualiseren
	setChangedValue (element);
}
/*
// Setzen select value
function content_setSelectValue (element)
{
	// Value soll nicht am select-Element geaendert werden, sondern der Value selbst
	var path = makePathFromId (element.id);
	var id_inp = makeIdFromPath ("inp_", path)
	element.id = id_inp;
	//alert (element.value);
	//alert (element.id);
	//alert (element.selectedIndex);

	// value Anzeige aktualisieren
	document.getElementById(id_inp).value = element.value;

	// statt des values muss hier der Index uebergeben werden
	// Objekt bauen
	if (module == "content")
		obj = json_instance;	
	else if (module == "ports")	
	{
		obj = portData;	
		portChange = 1;		// Flag fuer Konfig-Aenderung setzen	
	}

	var pathArr = path.split(",");
	for (var i=0; i<pathArr.length-1; i++)
	{
		if (pathArr[i].charAt(0) == '[')				// innerhalb eines arrays
			obj = obj[pathArr[i].slice(1,-1)];			// [] entfernen
		else
			obj = obj[pathArr[i]];
	}

	// das zu setzende Element soll von der gleichen Art sein, wie das bestehende
	// (also int, string oder bool)
	// alert (typeof obj[pathArr[pathArr.length-1]]);	
	var value = element.selectedIndex;									// string, default
	if (typeof obj[pathArr[pathArr.length-1]] === "number")
		value = parseInt(value);										// number
	obj[pathArr[pathArr.length-1]] = value;
	// document.write(JSON.stringify (obj, null, 4));	
}
*/
// ********************************************************************************************
// Setzen Checkbox value
function setCheckedValue (element)
{
	// Value soll die Summe aller per checkbox uebergebenen values sein
	var path = makePathFromId (element.id);

	// value Anzeige aktualisieren
	var val = 0;
	for (var i=0; i<16; i++)
	{
		if (i <=9 )		var id_chk = makeIdFromPath ("c0"+i+"_", path);		// Beispiel c01_...
		else			var id_chk = makeIdFromPath ("c"+i+"_", path);		// Beispiel c11_...		

		if (document.getElementById(id_chk) == undefined)
			break;

		if (document.getElementById(id_chk).checked == true)
			val += parseInt(document.getElementById(id_chk).value);
	}

	// berechneten Wert in input-Feld setzen
	var id_inp = makeIdFromPath ("inp_", path)
	document.getElementById(id_inp).value = element.value = val;
	
	
	// JSON-Instanz aktualiseren
	setChangedValue (element);
}

// ********************************************************************************************
// ********************************************************************************************

var interval = 0;		// globale Var. zum Stoppen von setInterval()
var id_dateTime;		// globale Var. fuer Zeit-ID fuer setInterval()

// PC-Zeit setzen
function setPCTime(event) 
{
	// alert (event.target.getAttribute("id"));

	var path = makePathFromId (event.target.getAttribute("id"));
	id_dateTime = makeIdFromPath ("inp_", path)
	// alert (id_dateTime);

	getPCTime (id_dateTime);
	clearInterval (interval);
//	interval = setInterval("getPCTime(id_dateTime)", 1000);
}

// PC- Datum ausgeben
function getPCTime (id)
{
	var element = document.getElementById(id);
	var datum = new Date();

	// Element in Oberflaeche setzen
	element.value = setLeadNull (datum.getFullYear()-0) + "-";		// Jahreszahl 4-stellig
	element.value += setLeadNull (datum.getMonth()+1-0) + "-";		// getMonth() von 0 ... 11
	element.value += setLeadNull (datum.getDate()-0) + "T";
	element.value += setLeadNull (datum.getHours()-0) + ":";
	element.value += setLeadNull (datum.getMinutes()-0) + ":";
	element.value += setLeadNull (datum.getSeconds()-0) + "Z";

	// Element in JSON-Objekt setzen
	setChangedValue (element);
}

// Intervall beenden
function timerReset()
{
	clearInterval (interval);
}

// ********************************************************************************************
/*
function setInvalidMessage (element)
{
	// Pfad aus ID ermitteln
	var path = makePathFromId (element.id);
	var pathArr = path.split(",");
	
	// Objekt bauen
	if (module == "content")
		obj = json_instance;	

	for (var i=0; i<pathArr.length-1; i++)
	{
		if (pathArr[i].charAt(0) == '[')				// innerhalb eines arrays
			obj = obj[pathArr[i].slice(1,-1)];			// [] entfernen
		else
			obj = obj[pathArr[i]];
	}

	// das zu setzende Element soll von der gleichen Art sein, wie das bestehende
	// (also int, string oder bool)
	// alert (typeof obj[pathArr[pathArr.length-1]]);	
	var value = element.value;									// string, default
	if (typeof obj[pathArr[pathArr.length-1]] === "number")
		value = parseInt(element.value);						// number

	alert ("value " + value + "is invalid!");

//	obj[pathArr[pathArr.length-1]] = value;
	
	// alert (JSON.stringify (obj, null, 4));	
	// alert (JSON.stringify (json_instance, null, 4));
	// document.write(JSON.stringify (obj, null, 4));	

}
*/
// ********************************************************************************************
// Setzen Checkbox value fuer boolsches Element
function setCheckedValueBool (element)
{

	var path = makePathFromId (element.id);

	// value Anzeige aktualisieren
	var val = 0;
	var id_chk = makeIdFromPath ("chb_", path);	

	// Wert in input-Feld setzen und in value der checkBox
	var id_inp = makeIdFromPath ("inp_", path)
	if (document.getElementById(id_chk).checked == true)
	{
//		document.getElementById(id_inp).value = "true";
		document.getElementById(id_chk).value = "true";	
	}
	else
	{
//		document.getElementById(id_inp).value = "false";
		document.getElementById(id_chk).value = "false";	
	}	

	// JSON-Instanz aktualiseren
	setChangedValue (element);

	// Abhaengigkeiten aktualisieren,
	// dazu content neu aufbauen
	setContent (content.key, content.value, content.type, content.path);
}

// ********************************************************************************************
// fuehrende Nullen auffuellen
function addLeadingZeros (number, length)
{
	var num = '' + number;
	while (num.length < length)
		num = '0' + num;
	return num;
}

// ********************************************************************************************
// Funktion durch button ausgeloest
function set(event) 
{
	// alert (event.target.getAttribute("id"));
	
	// Pfad des ausloesenden elements ermitteln
	var path = makePathFromId (event.target.getAttribute("id"));
	id_path = makeIdFromPath ("inp_", path)
	// alert (id_path);

	// key aus Pfad ermitteln
	var pathArr = id_path.split("/");
	var key = pathArr[pathArr.length-1];
	// alert (key);

	// value ermitteln
	var value = document.getElementById(id_path).value;
	value = addLeadingZeros (value, 2);
	// alert (value);
		
	// frame aktualisieren
	// Pfad ermitteln
	id_path = "";
	pathArr[pathArr.length-1] = "frame";
	for (i=0; i<pathArr.length; i++)
	{
		id_path += pathArr[i];
		if (i < (pathArr.length - 1))
			id_path += "/";	
	}
	// alert (id_path);

	// value in frame einsetzen
	var frame = document.getElementById(id_path).value;
	
	var keyTag = "<"+key+">";
	var regexp = new RegExp(keyTag, "g");
	frame = frame.replace(regexp, value);				// <xxx> ersetzt durch Wert aus xxx
	document.getElementById(id_path).value = frame;

}

// ********************************************************************************************
// Funktion durch checkbox ausgeloest
function selectEntry(event) 
{
	// alert (event.target.getAttribute("id"));
	
	// Pfad der ausloesenden checkbox ermitteln
	var path = makePathFromId (event.target.getAttribute("id"));
	var id_chk = makeIdFromPath ("chk_", path)
	// alert (id_chk);

	// Pfad des zugehoerigen elements ermitteln
	var id_inp = makeIdFromPath ("inp_", path)
	// alert (id_inp);

	// Pfad des zugehoerigen div ermitteln
	var pathArr = path.split(",");
	var path_2 = pathArr[pathArr.length - 3];		// zB RX
	var id_div = makeIdFromPath ("div_", path_2)
	// alert (id_div);
	// alert (document.getElementById(id_div).innerHTML);

	// key aus Pfad ermitteln
	var pathArr = id_inp.split("/");
	var key = pathArr[pathArr.length-1];
	// alert (key);

	// checked state ermitteln
	var checked = document.getElementById(id_chk).checked;
	// alert (checked);

	// wenn checked, Parametrierung einblenden
	if (checked == true)
		channel_tabsOpen (path);

}

// ********************************************************************************************
// Funktion durch button ausgeloest
function setCounterOptions(event) 
{
	// alert (event.target.getAttribute("id"));

	// Pfad des ausloesenden elements ermitteln
	var path = makePathFromId (event.target.getAttribute("id"));
	id_path = makeIdFromPath ("inp_", path)

	counter_tabsOpen (path);
}

// ********************************************************************************************
// Ausgabe der Elemente eines Objekts
function dumpObject(obj) 
{
	var s = '';
	for (var i in obj) 
		s += i + ': '+obj[i]+"\n";
	alert(s);
}

// ********************************************************************************************
// ********************************************************************************************

