/**********************************************************************************************
	JS functions for browser select
	
	Copyright (c) 2008 MCQ TECH GmbH (rstiawa@metz-connect.com)
	Version 0.2		12.2008

***********************************************************************************************/

/*
	Browser Check
*/

// ********************************************************************************************


var browser = "unbekannt";
var appVersion;
var DOM_version = "--";
var AJAX_version = "--";
var browser_debug = 0;			// Debug-Ausgaben


// Typ und Version des verwendeten Browsers
function browserCheck()
{

	// Browser-Varianten
	var userAgent = navigator.appName.toLowerCase();
	if (userAgent.indexOf("netscape") != -1) browser = "netscape";
	if (userAgent.indexOf("explorer") != -1) browser = "internet explorer";
	
	// alert ("Version = "+navigator.appVersion);
	if (browser == "netscape")
	{
		appVersion = parseFloat(navigator.appVersion);
	}

	if (browser == "internet explorer")
	{
		var index = navigator.appVersion.indexOf("MSIE");
		if (index == -1) 
			appVersion = 4;
		else
		{
			var iString = navigator.appVersion.slice(index+5, index+8);
			appVersion = parseFloat(iString);
		}			
	}
	
	// DOM-Varianten
	var ie = document.all;
	var w3c = document.documentElement;
	
	if (ie)	
		DOM_version = "IE-DOM";
	else if (w3c)
		DOM_version = "W3C-DOM";

	
	// AJAX- Kompatibilitaet
	if (window.XMLHttpRequest) 
	{
		// XMLHttpRequest fr Firefox, Opera, Safari, ...
		AJAX_version = "XMLHTTP nativ";
	} 
	else if (window.ActiveXObject) 
	{
		try 
		{   
			//XMLHTTP (neu) fr Internet Explorer 
			new ActiveXObject("Msxml2.XMLHTTP");
			AJAX_version = "XMLHTTP(neu) fr IE";
		} 
		catch(e) 
		{
			try 
			{        
				//XMLHTTP (alt) fr Internet Explorer
				new ActiveXObject("Microsoft.XMLHTTP");  
				AJAX_version = "XMLHTTP(alt) fr IE";
			} 
			catch (e) 
			{}
		}
	}

	if (browser_debug)
	{	
		alert 	("Browser = "+browser+" "+appVersion+"\n"
				+"DOM = "+DOM_version+"\n"
				+"AJAX = "+AJAX_version+"\n"
				+"Screen = "+screen.width+" x "+screen.height);
	}		
}

// ********************************************************************************************

// Auswertung der ermittelten Browser-Parameter
function browserEvaluation ()
{
	var browser_err = "";
	var version_err = "";
	var DOM_err = "";
	var AJAX_err = "";
	
	
	if (browser == "unbekannt")
		browser_err = ins("browser_unknown");

	if ((browser == "internet explorer") && (appVersion < 7))
		version_err = ins("browser_ie_old");

	if ((browser == "netscape") && (appVersion < 5))
		version_err = ins("browser_ff_old");

	if (DOM_version == "--")
		DOM_err = ins("browser_no_dom");

	if (AJAX_version == "--")
		AJAX_err = 	ins("browser_no_ajax");
		
	if (browser_err || version_err || DOM_err || AJAX_err)
	{	
		alert	(ins("browser_check")+browser_err+version_err+DOM_err+AJAX_err);
	}
	
	
}

// ********************************************************************************************

// Test
// Darstellungsmode Document-Type der HTML- Seite
function testDocumentType()
{	
	
	// Darstellungsmode
	// Quirks-Mode: Ausgabe "BackCompat" oder "Quirksmode"
	// Standards-Mode: Ausgabe "CSS1Compat"
	alert("Darstellungsmodus:" + document.compatMode);
}


// ********************************************************************************************
// JavaScript aktiv?
// In HTML wird ein "Deaktiv"- Text ausgegeben.
// Diese Ausgabe wird bei aktiviertem JavaScript versteckt.
// Der Aufruf dieser Funktion muss unmittelbar hinter dem HTML- Text erfolgen, damit der Text
// zuverlaessig unterdrueckt wird!
function checkJS()
{
	var ie = document.all;
	var w3c = document.documentElement;
	
	if (ie || w3c)	
		document.getElementById("js_activ").style.visibility = 'hidden';
}

// ********************************************************************************************

// Initialisierung
function load_browser()
{
	checkJS();					// Pruefen, ob JS im Browser aktiviert ist
	browserCheck();				// Pruefen: Browsertyp, DOM, AJAX, Bildschirmaufloesung
	browserEvaluation();		// Auswertung browserCheck
}

// ********************************************************************************************
