/**********************************************************************************************
	JS functions for applications

	Copyright (c) 2009 MCQ TECH GmbH (rstiawa@metz-connect.com) 
	Version 1.0		08.2010

***********************************************************************************************/


// ********************************************************************************************

var DEBUG_APP = 0;			// Ausgaben

var localObject;
var mailcnt = 0;			// fuer mail- Funktionsnamen
var oStr;					// Aktualisierung Tree

// ********************************************************************************************
// ********************************************************************************************
// Initialisierung beim Start der page: Daten aktualisieren
function initSide()
{
	// Buttonbeschriftung
	initButtons();

	// URL und Name der Applikation
	var page = top.tree_getPageName(); 	
	if (DEBUG_APP)
		alert (top.frame_content.location.href+"   "+page[0]);
	
	// Nach dem Aufbau der page sollen die Felder mit den Eigenschaften des Objekts gefuellt werden,
	// wenn die Seite bereits besteht
	if (page[0] != "newApplication")
	{
		top.document.getElementById("button_1").onclick();
	
		// Namen in Eingabefeld setzen, Konfiguration unsichtbar
		document.form_newName.appName.value = page[0];
		document.form_comment.style.display = "none";
	}
	else
	{
		// newApplication
		activateConfiguration();
		document.form_activateConfigButton.style.display = "none";
	
		// Standardtext setzen
		top.getDataExtended ("test", "connection", "top.frame_content.setDefaultText(actStr)");

		// evtl. sichtbaren IntervallButton disabeln
		top.document.form_interval.style.display = "none";
	
	}
	
	// Titel setzen
	var headLine = document.getElementById("headLine");		
	headLine.innerHTML = page[0];	
}

// ********************************************************************************************
// Aufruf der Aktualisierungsfunktionen (EWIO -> Browser)
function setObjectProperties (actObject)
{
	// Werte setzen	
	setData (actObject);
	
	// Objekt global speichern fuer getObjectProperties()
	localObject = actObject;	
}

// ********************************************************************************************
// Aufruf der Aktualisierungsfunktionen (Browser -> EWIO)
function getObjectProperties()
{

	// Nur Administrator/Operator sendet
	if ((top.g_username == "Administrator") ||
		(top.g_username == "Operator"))
	{
		// Werte ermitteln	
		if (typeof(localObject) != "object")
			localObject = new Object();
	
		var changedObject = getData(localObject);
		return (changedObject);
	}
	else
	{
		// MessageBox
		top.messageBox_Login ("Administrator / Operator");
		return;	
	}
}

// ********************************************************************************************
// ********************************************************************************************
// Werte setzen
function setData (appObject)
{
	// Einstellungen enstsprechend JSON- Objekt setzen

	// name
	
	// runMode
	if (appObject.run != "undefined")
	{
		if (appObject.run == 1)
			document.form_startstop.r0[0].checked = true;
		else
			document.form_startstop.r0[1].checked = true;
	}

	// script
	document.form_script.script.value = appObject.script;
}

// ********************************************************************************************
// Werte lesen
function getData (appObject)	
{
	// Objekt-Elemente zuweisen

	// name
	var name = top.frame_content.document.form_newName.appName.value;
	
	// Fehler, wenn kein eigener Name gewaehlt wurde
	if (name == "newApplication")
	{
		// MessageBox
		var headline = ins("app_mb_name");
		var text = ins("app_mb_othername");
		top.messageBox (headline, text);	
		return;	
	}

	// Fehler, wenn unerlaubtes Zeichen (nur a-z, A-Z, 0-9, _)
	if (checkSyntax(name) == false)
	{
		// MessageBox
		var headline = ins("app_mb_name");
		var text = ins("app_mb_char");
		top.messageBox (headline, text);	
		return;	
	}

//	top.tree_pageName = name;
	tree_setPageName (name);
	appObject.name = name;

	// kill
	if (document.form_kill.kill.checked == true)
		appObject.kill = 1;
	else
		appObject.kill = 0;

	// runMode
	if (document.form_startstop.r0[0].checked == true)
		appObject.run = 1;
	else	
		appObject.run = 0;

	// script
	appObject.script = document.form_script.script.value; 
	
	//var actString = JSON2.stringify (appObject, null, 4);
	//alert (actString);
	
	return (appObject);
}


// ********************************************************************************************

// Konfiguration sichtbar / unsichtbar
function activateConfiguration()
{

	// Nur Administrator darf Konfiguration aendern	
	if (top.g_username != "Administrator")
	{
		top.messageBox_Login ("Administrator");
		return;
	}

	if (document.form_newName.style.display == "block")
	{	
		// Konfiguration deaktivieren
		document.form_newName.style.display = "none";
		document.form_kill.style.display = "none";
		document.form_tools.style.display = "none";
	}
	else
	{
		// Konfiguration aktivieren
		document.form_newName.style.display = "block";
		document.form_kill.style.display = "block";
		document.form_tools.style.display = "block";
	}
}

// Konfiguration Tools io oeffnen
function openPad_io()
{
	var headline =  '<B>'+ins("app_port_rw")+'</B>';
	content =		'<form name="form_io">'+ 		
					'<div class="pos x0101 textfield">'+ins("app_out_console")+'</div>'+
					'<div class="pos x0103 textfield"><input name="console" type="checkbox"></div>'+
					'<div class="pos x0201 textfield">'+ins("app_port_type")+'</div>'+
					'<div class="pos x0203 textfield">'+
					'<input type="radio" name="r0" value="0">'+ins("app_read")+
					'<input type="radio" name="r0" value="1" checked="true">'+ins("app_write")+
					'</div>'+

					'<div class="pos x0301 textfield">'+ins("app_port_select")+'</div>'+
					'<div class="pos x0303">'+
					'<select name="selectEWIO" size=1 class="combobox long_200" onChange="fSelectIODriver()"></select><br>'+
					'<select name="selectIODriver" size=1 class="combobox long_200" onChange="fSelectIOPort()"></select><br>'+
					'<select name="selectIOPort" size=1 class="combobox long_200"></select>'+
					'</div>'+

					'<div id="button_position">'+
					'<input type="button" class="button_ok" name="ok" value="OK" onClick="fSetPort(1)">'+
					'<input type="button" class="button_cancel" name="cancel" value="Cancel" onClick="fSetPort(0)">'+
					'</div>'+
					'</form>';
	
	guiPopup.Show ("message", headline, content, 'IO', 400, 220, "window");

	// Portauswahl aktivieren
	selectIOPorts();
}

// Konfiguration Tools cycle oeffnen
function openPad_cycle()
{
	var headline =  '<B>'+ins("app_change_cycle")+'</B>';
	content =		'<form name="form_cycle">'+ 		
					'<div class="pos x0101 textfield">'+ins("app_cycle_time")+'</div>'+
					'<div class="pos x0103">'+
					'<input type="text" class="textfield" value="1000" name="cycle" size="10">'+
					'</div>'+

					'<div id="button_position">'+
					'<input type="button" class="button_ok" name="ok" value="OK" onClick="fSetCycle(1)">'+
					'<input type="button" class="button_cancel" name="cancel" value="Cancel" onClick="fSetCycle(0)">'+
					'</div>'+
					'</form>';
	
	guiPopup.Show ("message", headline, content, 'Cycle', 400, 110, "window");
}

// Konfiguration Tools sensor oeffnen
function openPad_sensor()
{
	var headline =  '<B>'+ins("app_sensor")+'</B>';
	content =		'<form name="form_sensor">'+ 		
					'<div class="pos x0101 textfield">'+ins("app_sensor_type")+'</div>'+
					'<div class="pos x0103">'+
					'<select name="selectSensortype" size=1 class="combobox long_100">'+
					'<OPTION value="PT100"> PT100 </OPTION>'+ 
					'<OPTION value="PT500"> PT500 </OPTION>'+ 
					'<OPTION value="PT1000"> PT1000 </OPTION>'+ 
					'</select><br>'+
					'</div>'+

					'<div class="pos x0201 textfield">'+ins("app_sensor_temp")+'</div>'+
					'<div class="pos x0203">'+
					'<select name="selectUnit" size=1 class="combobox long_100">'+
					'<OPTION value="C"> Celsius </OPTION>'+ 
					'<OPTION value="K"> Kelvin </OPTION>'+ 
					'<OPTION value="F"> Fahrenheit </OPTION>'+ 
					'</select><br>'+
					'</div>'+

					'<div class="pos x0301 textfield">'+ins("app_sensor_out")+'</div>'+
					'<div class="pos x0303">'+
					'<select name="selectOutputType" size=1 class="combobox long_200">'+
					'<OPTION value="INT"> Integer (for processing) </OPTION>'+ 
					'<OPTION value="FLOAT"> Float (for output) </OPTION>'+ 
					'</select><br>'+
					'</div>'+

					'<div id="button_position">'+
					'<input type="button" class="button_ok" name="ok" value="OK" onClick="fSetSensor(1)">'+
					'<input type="button" class="button_cancel" name="cancel" value="Cancel" onClick="fSetSensor(0)">'+
					'</div>'+
					'</form>';
	
	guiPopup.Show ("message", headline, content, 'Sensor', 400, 150, "window");
}

// Konfiguration Tools eMail oeffnen
function openPad_eMail()
{
	var headline =  '<B>eMail</B>';
	content =		'<form name="form_email">'+ 		
					'<div class="pos x0101 textfield">'+ins("app_email_from")+'</div>'+
					'<div class="pos x0103"> <input type="text" class="textfield long_200" value="mc-ewio@t-online.de" name="from"> </div>'+
					'<div class="pos x0201 textfield">'+ins("app_email_to")+'</div>'+
					'<div class="pos x0203"> <input type="text" class="textfield long_200" value="myName@provider.com" name="to"> </div>'+
					'<div class="pos x0301 textfield"> SSL </div>'+
					'<div class="pos x0303"> <input type="checkbox" name="ssl" checked="checked"> </div>'+
					'<div class="pos x0401 textfield"> MailServer </div>'+
					'<div class="pos x0403"> <input type="text" class="textfield long_200" value="securesmtp.t-online.de:465" name="mailserver"> </div>'+
					'<div class="pos x0501 textfield">'+ins("app_email_user")+'</div>'+
					'<div class="pos x0503"> <input type="text" class="textfield long_200" value="mc-ewio@t-online.de" name="username"> </div>'+
					'<div class="pos x0601 textfield">'+ins("app_email_pass")+'</div>'+
					'<div class="pos x0603"> <input type="password" class="textfield long_200" value="Cassiopeia1" name="password"> </div>'+

					'<div class="pos x0801 textfield">'+ins("app_email_subject")+'</div>'+
					'<div class="pos x0803"> <input type="text" class="textfield long_200" value="subject" name="subject"> </div>'+
					'<div class="pos x0901 textfield">'+ins("app_email_text")+'</div>'+
					'<div class="pos x0903"> <textarea name="body" class="textfield long_200" rows="3">text</textarea></div>'+

					'<div id="button_position">'+
					'<input type="button" class="button_ok" name="ok" value="OK" onClick="fSetMail(1)">'+
					'<input type="button" class="button_cancel" name="cancel" value="Cancel" onClick="fSetMail(0)">'+
					'</div>'+
					'</form>';
	
	guiPopup.Show ("message", headline, content, 'Email', 400, 350, "window");
}

// ********************************************************************************************
// ********************************************************************************************

// Konfiguration Tools Cycle
// Funktion nach Aendern Zykluszeit
function fSetCycle(valid)
{

	if (valid)
	{
		var cycle = parseInt(document.form_cycle.cycle.value);
		if (cycle < 100)	cycle = 100;
		cycle = cycle*1000;		// ms -> us
		changeScriptText ("CYCLE=", '\n', String(cycle));		
	}
	
	//document.form_cycle.style.display = "none";
	guiPopup.CloseMe("message");
}


// ********************************************************************************************
// ********************************************************************************************

// Konfiguration Tools io
function selectIOPorts ()
{
	// Links holen
	top.getDataExtended ("links", "configuration", "top.frame_content.selectIOPorts_answer(actStr)");
}

// ********************************************************************************************

// Konfiguration Tools io
function selectIOPorts_answer(actStr)
{ 
	if (DEBUG_APP)	
		alert (actStr);

	// wenn kein JSON -> Abbruch
	if (actStr.indexOf("{") == -1)
		return;

	// JSON-String in Objekt wandeln
	jObject = JSON2.parse(actStr);


	// Auswahl EWIO
	fSelectEWIO (jObject);

	// Auswahl IO-Treiber
	// fSelectIODriver() wird aufgerufen aus fSelectEWIO()
	
	// IO-Port
	// fSelectIOPort() wird aufgerufen aus getSelectIODriver()	
}

// ********************************************************************************************

function fSelectEWIO (jLinks)
{

	// Namen des eigenen und der in der links-Liste angegebenen EWIO ermitteln;

	// Listenelemente dynamisch hinzufuegen
	var list = eval ("document.form_io.selectEWIO");
	list.options.length = 0;

	// eigener EWIO
	var name = top.getDeviceName ();
	list.options[list.options.length] = 
		new Option (name, name, false, false);

	// Links
	for (var i=0; i<jObject.links.length; i++)
	{
		list.options[list.options.length] = 
			new Option (jObject.links[i].name, jObject.links[i].host_or_ip, false, false);
	}

	list.selectedIndex = 0;

	// Auswahl IO-Treiber
	fSelectIODriver();
}

// ********************************************************************************************

// Driver Laden
function fSelectIODriver()
{

	// get selected index
	var index = top.frame_content.document.form_io.selectEWIO.selectedIndex;

	// get value
	var device = top.frame_content.document.form_io.selectEWIO[index].text;
	var value = top.frame_content.document.form_io.selectEWIO[index].value;

	// alert ("fSelectIODriver: "+device+"   "+last_device);
	last_device = device;

	if (value.indexOf("http") != -1)
	{
		// alert ("driver remote");
		top.getDataExtended (value+"/driver", "configuration", "top.frame_content.getSelectIODriver(actStr)");
	}		
	else
		top.getDataExtended ("driver", "configuration", "top.frame_content.getSelectIODriver(actStr)");
}

// Geladene Driver in Select-Box einfuegen
function getSelectIODriver(actStr)
{
	var content = "json = "+actStr;
	if (DEBUG_APP)	alert (content);

	// bei Fehler Abbruch
	if (getErrorMsg (content))
	{
		guiPopup.CloseMe("message");
		return;
	}

	var jsonTempl = eval (content);

	var nameArr = new Array();
	var valArr = new Array();


	var j = 0;
	while (1)
	{
		var obj = jsonTempl.driver_list[j];

		var arrAll = getObjectsAsArray(obj);
		if (arrAll == 0)
			break;
		
		var key = arrAll[0];
		var	val = arrAll[1];

		var valStr = "";
		for (var i=0; i<key.length; i++)
		{
//			alert (key[i]);
			if (key[i] == "name")
			{
				if (val[i] != "no more entry")
					nameArr[nameArr.length] = val[i];
//				alert (key[i]+"   "+val[i]);
			}
		}
		j++;
	}

//	alert (nameArr);

	// ComboBox fuellen
	// Listenelemente dynamisch hinzufuegen
	var list = eval ("document.form_io.selectIODriver");
	list.options.length = 0;
	for (var j=0; j<nameArr.length; j++)
	{
		list.options[list.options.length] = 
		new Option (nameArr[j], nameArr[j], false, false);			// name, name, ...
		list.selectedIndex = 0;
	}

	// IO-Port
	fSelectIOPort();	
}

// ********************************************************************************************

// IO-Ports - Zusaetzliche Daten laden
function fSelectIOPort()
{

	// get selected driver
	var index = top.frame_content.document.form_io.selectIODriver.selectedIndex;
	var driver = top.frame_content.document.form_io.selectIODriver[index].text;

	// get selected device-value
	var index = top.frame_content.document.form_io.selectEWIO.selectedIndex;
	var value = top.frame_content.document.form_io.selectEWIO[index].value;		

	// alert ("fSelectIOPort: "+driver+"   "+value);

	if (value.indexOf("http") != -1)
		top.getDataExtended (value+"/"+driver, "configuration", "top.frame_content.getSelectIOPort(actStr)");
	else
		top.getDataExtended (driver, "configuration", "top.frame_content.getSelectIOPort(actStr)");
}



// IO-Ports - Zusaetzliche Daten auswerten
function getSelectIOPort(actStr)
{

	var content = "json = "+actStr;
	if (DEBUG_APP)	alert (content);
	var jsonTempl = eval (content);

	var nameArr = new Array();
	var portArr = new Array();


	var j = 0;
	while (1)
	{
		if (jsonTempl.oDevices == undefined)
		{
			// Einzel-Device
			var obj = jsonTempl.oDevice;
			if (j >= 1)
				break;
		}
		else
		{	
			// Device-Array			
			var obj = jsonTempl.oDevices[j];
		}

		var arrAll = getObjectsAsArray(obj);
		if (arrAll == 0)
			break;
		
		var key = arrAll[0];
		var	val = arrAll[1];

		// alert (key);
		// alert (val);

		var portStr = "";
		for (var i=0; i<key.length; i++)
		{
			// alert (key[i]);

			if (key[i] == "Name")
			{
				nameArr[nameArr.length] = val[i];
//				alert (key[i]+"   "+val[i]);
			}

			if (key[i] == "oValue")
			{
//				alert (jsonTempl.oDevices[j].oValue.Name);
				if (jsonTempl.oDevices != undefined)
					portArr[portArr.length] = jsonTempl.oDevices[j].oValue.Name;
				else
					portArr[portArr.length] = jsonTempl.oDevice.oValue.Name;
			}

			if (key[i] == "oValues")
			{
				if (jsonTempl.oDevices[j].oValues[0]) 			// Array?
				{					
//					alert ("array");
//					alert ("oValues length = "+jsonTempl.oDevices[j].oValues.length);

					// letzten nameArr loeschen
					var lastName = nameArr[nameArr.length - 1];					
					nameArr.pop(); 

					// Werte aus dem Array ermitteln
					var bitShift = 0;
					for (var k=0; k<jsonTempl.oDevices[j].oValues.length; k++)
					{						
//						alert (k+" = "+jsonTempl.oDevices[j].oValues[k].Name);
						portArr[portArr.length] = jsonTempl.oDevices[j].oValues[k].Name;
					
						// Aktualisierung nameArr
						var bitSize = jsonTempl.oDevices[j].oValues[k].Size;
						nameArr[nameArr.length] = lastName + "/" + bitShift + "/" + bitSize;
						bitShift += bitSize;
					}
				}
			}

		}
		j++;
	}

/*	
		var portStr = "";
		for (var i=0; i<arr.length; i++)
			portStr += (arr[i]+"   "+val[i]+"\n"); 
		alert (portStr);
*/	

//	alert (nameArr);

	// ComboBox fuellen
	// Listenelemente dynamisch hinzufuegen
	var list = eval ("document.form_io.selectIOPort");
	list.options.length = 0;
	for (var j=0; j<portArr.length; j++)
	{
		list.options[list.options.length] = 
		new Option (portArr[j], nameArr[j], false, false);			// Name, Value, ...
		// Alternativ: addSelectOption (formName, formProp[i].label[j])
					
		list.selectedIndex = 0;
	}
}



// ********************************************************************************************

// IO-Port in Script setzen
function fSetPort(valid)			
{
	var value = new Array();
	var name;
	var index;
	var text = "";

	var path_io 		= "/sys/bus/platform/drivers/";
//	var path_io_extern 	= "/usr/local/external_devices/";
	var path_io_extern 	= "/sys/bus/platform/drivers/";



	if (valid)
	{		
		// Auswahl der ComboBoxen ermitteln	
		index = document.form_io.selectEWIO.selectedIndex;
		value[0] = document.form_io.selectEWIO[index].value;

		index = document.form_io.selectIODriver.selectedIndex;
		value[1] = document.form_io.selectIODriver[index].value;

		index = document.form_io.selectIOPort.selectedIndex;
		value[2] = document.form_io.selectIOPort[index].value;
		value[3] = document.form_io.selectIOPort[index].text;
		value[3] = deleteWhitespace (value[3]);		// evtl. Leerzeichen aus Namen entfernen
		value[3] = finishText (value[3]);			// Namen bis zur ersten Klammer

		// read / write
		if (document.form_io.r0[0].checked == true)
			var varName = "read_"+value[3];			// read
		else
			var varName = "write_"+value[3];		// write
	
		// input/output
		var portType;
		if ((value[2].indexOf("_do") !== -1) ||
			(value[2].indexOf("_to") !== -1) ||	
			(value[2].indexOf("_ao") !== -1) )	
			portType = "output";
		else
			portType = "input";
	
		// float/int	// nur bei analog-input values
		var floatconv;
		if (value[2].indexOf("_ai") !== -1)	
			floatconv = 1;
		else
			floatconv = 0;


		// an value[2] sind beim bit-Array die Parameter fuer bitSize und bitShift angehaengt,
		// getrennt durch "/"
		if (value[2].indexOf("/") !== -1)
		{
			// bit-Array: bitShift und bitSize(->bitMask) bearbeiten
			var bitShiftPos = value[2].indexOf('/');
			var bitShift = parseInt(value[2].substring(bitShiftPos + 1));

			var bitSizePos = value[2].lastIndexOf('/');
			var bitSize = parseInt(value[2].substring(bitSizePos + 1));  
			var bitMask = Math.pow(2,bitSize) - 1;		// BitMaske = (2 hoch x) - 1, x=bitSize

			value[2] = value[2].substring(0, bitShiftPos);
		}

		if (DEBUG_APP)
 		{
			alert ("value[0] = "+value[0]+"     value[1] = "+value[1]+"     value[2] = "+value[2]);
			alert ("bitShift = "+bitShift+"     bitSize  = "+bitSize+"      bitMask  = "+bitMask);
		}

		// console
		if (document.form_io.console.checked == true)
			var printConsole = 1;
		else
			var printConsole = 0;


		
		// Funktion in Script einfuegen
		if (value[0].indexOf("http") != -1)
		{
			// fremder EWIO

			text += "\n";
			text += varName+"()\n";
			text += "{\n";
			
			// read / write	
			if (document.form_io.r0[0].checked == true)
			{
				// read
				if ((bitShift !== undefined) && (bitMask !== undefined))
				{
					// bit-Werte
					var mask = bitMask << bitShift;
					text += varName+"=$(/config/bin/httpClient "+value[0]+" singlevaluemask "+value[1]+"/"+value[2]+"/"+portType+
							":"+mask+" read)\n";			
					text += varName+"=$(("+varName+" >> "+bitShift+"))\n";				
				}
				else
				{
					// Byte-Wert
					text += varName+"=$(/config/bin/httpClient "+value[0]+" singlevaluemask "+value[1]+"/"+value[2]+"/"+portType+" read)\n";
				}
				if (printConsole)	text += "echo "+varName+" = $"+varName+"\n";
			}
			else
			{
				// write
				if ((bitShift !== undefined) && (bitMask !== undefined))
				{
					// bit-Werte
					var mask = bitMask << bitShift;
					text += varName+"=$(($1 << "+bitShift+"))\n";
					text += "/config/bin/httpClient "+value[0]+" singlevaluemask "+value[1]+"/"+value[2]+"/"+portType+
							":"+mask+" write $"+varName+"\n";		
				}
				else
				{
					// Byte-Wert
					text += "/config/bin/httpClient "+value[0]+" singlevaluemask "+value[1]+"/"+value[2]+"/"+portType+" write $1\n";
				}
				if (printConsole)	text += "echo "+varName+" = $1\n";
			}
	
			text += "}\n";	
		}
		else
		{
			// eigener EWIO

			if (value[1].indexOf("mct_paa_") != -1)
				var path_driver = path_io_extern;
			else
				var path_driver = path_io;
	
			text += "\n";
			text += varName+"()\n";
			text += "{\n";
			text += "io=";
			text += "\""+path_driver;
			text += value[1]+"/"+value[2]+"/"+portType+"\"\n";

			// read / write	
			if (document.form_io.r0[0].checked == true)
			{
				// read
				if ((bitShift !== undefined) && (bitMask !== undefined))
				{
					var mask = bitMask << bitShift;
					text += varName+"=$(/config/bin/get_io $io "+mask+")\n";		// io lesen
					text += varName+"=$(("+varName+" >> "+bitShift+"))\n";				
				}
				else
				{				
					text += varName+"=$(/config/bin/get_io $io)\n";		// io lesen
				}				
				if (printConsole)	text += "echo "+varName+" = $"+varName+"\n";
			}
			else
			{
				// write
				if ((bitShift !== undefined) && (bitMask !== undefined))
				{
					var mask = bitMask << bitShift;
					text += varName+"=$(($1 << "+bitShift+"))\n";
					text += "/config/bin/set_io $io $"+varName+" "+mask+"\n";		// io setzen
				}
				else
				{				
					text += "/config/bin/set_io $io $1\n";		// io setzen
				}				
				if (printConsole)	text += "echo "+varName+" = $1\n";
			}

			text += "}\n";
		}

		// Funktion einfuegen
		var script = document.form_script.script.value;		
		if (script.indexOf("\r\n") != -1)
			changeScriptText ("# Declaration:\r\n", "\r\n", text);		// Windows
		else
			changeScriptText ("# Declaration:\n", '\n', text);			
	}

	// pad schliessen
	guiPopup.CloseMe("message");

}

// ********************************************************************************************
// ********************************************************************************************

// Konfiguration Tools / Sensor
function fSetSensor(valid)			
{

	if (valid)
	{

		// Auswahl der ComboBoxen ermitteln	
		var index = document.form_sensor.selectSensortype.selectedIndex;
		var sensor =  document.form_sensor.selectSensortype[index].value;

		index = document.form_sensor.selectUnit.selectedIndex;
		var unit = document.form_sensor.selectUnit[index].value;

		index = document.form_sensor.selectOutputType.selectedIndex;
		var outputType = document.form_sensor.selectOutputType[index].value;

		var text = "\n";
		text += "sensor_conv_"+sensor+"_"+unit+"_"+outputType+"()\n";
		text += "{\n";
		text += "sensor_conv_"+sensor+"_"+unit+"_"+outputType+"=$(/config/bin/sensor_conv $1 "+sensor+" "+unit+" "+outputType+")";
		text += "\n}";


		// Funktion einfuegen
		var script = document.form_script.script.value;		
		if (script.indexOf("\r\n") != -1)
			changeScriptText ("# Declaration:\r\n", "\r\n", text);		// Windows
		else
			changeScriptText ("# Declaration:\n", '\n', text);			
	}

	// pad schliessen
	guiPopup.CloseMe("message");

}

// ********************************************************************************************
// ********************************************************************************************

// Konfiguration Tools / eMail
function fSetMail (valid)
{

	if (valid)
	{
		// Parameter ermitteln
		var from = document.form_email.from.value;
		var to = document.form_email.to.value;

		var ssl = document.form_email.ssl.checked;					// true / false
		var mailserver = document.form_email.mailserver.value;
		var username = document.form_email.username.value;
		var password = document.form_email.password.value;

		var subject = document.form_email.subject.value;
		var body = document.form_email.body.value;

		//alert (from+"   "+to+"   "+mailserver+"   "+username+"   "+password+"   "+subject+"   "+body);
	
		// Kommando zusammenbauen: 
		// Es wird eine Funktion erzeugt und im Script eingefuegt 
		
		mailcnt++;
		var text = "\n";
		text += "sendmail_"+mailcnt+"()\n";
		text += "{\n";
		text += "email=\"/var/email\"\n";
		text += "echo \"From:"+from+"\" > $email\n";
		text += "echo \"Subject:"+subject+"\" >> $email\n";
		text += "echo \"\" >> $email\n";
		text += "echo \""+body+"\" >> $email\n";
		text += "echo $1 >> $email\n";
		if (ssl)
			text += "sendmail -f "+from+" -S 127.0.0.1:8828 -au"+username+" -ap"+password+" "+to+" < /var/email";
		else
			text += "sendmail -f "+from+" -S "+mailserver+" -au"+username+" -ap"+password+" "+to+" < /var/email";
		text += "\n}";

		// Funktion einfuegen
		var script = document.form_script.script.value;		
		if (script.indexOf("\r\n") != -1)
			changeScriptText ("# Declaration:\r\n", "\r\n", text);		// Windows
		else
			changeScriptText ("# Declaration:\n", '\n', text);			
	
		// stunnel.conf anpassen, wenn ssl
		top.setDataExtended ("application", "application_mail", mailserver);
	}

	// pad schliessen
	guiPopup.CloseMe("message");
}

// ********************************************************************************************
// ********************************************************************************************

// Ermitteln aller Teilobjekte und Eigenschaften innerhalb eines angegebenen Objektes
// param: Objekt 
// ret: Array mit enthaltenen Teil-Objekten und Eigenschaften
function getObjectsAsArray(obj)
{
	var prop = "";
	var i = 0;
	
	var arr = new Array();
	arr[0] = new Array();
	arr[1] = new Array();
	
	
	// Objekt vorhanden?
	if ( (typeof(obj) == "undefined") || (obj === null) ) 
		return (0);
		
	// Eigenschaft als string
	if (typeof(obj) == "string") 
		return (obj);

	// Eigenschaft als number -> string
	if (typeof(obj) == "number") 
		return (obj+"");

	// Objekt	
	if (typeof(obj) == "object")
	{
		for (prop in obj)
		{
			arr[0][i] = prop; 
			arr[1][i] = obj[prop];
			i++;
		}
	}
	return (arr);	// arr[0] enthaelt objekte, arr[1] enthaelt Eigenschaften
}	

// ********************************************************************************************

// Standardtext setzen
function setDefaultText(actStr)
{
	// kein JSON, also Fehlermeldung
	if (actStr.indexOf("{") == -1)
	{
		if (actStr.indexOf("LOGIN ERROR") != -1)	
		{
			// Wenn login-timeout abgelaufen ist, dann Fehlermeldung und Abbruch
			top.messageBox (ins("main_mb_errMsg"), ins("main_mb_errLogin")); 
		}
		else
		{
			// kein JSON, Ausgabe Fehlermeldung vom EWIO in MessageBox
			top.messageBox (ins("main_mb_errMsg"), top.getMessage (actStr));
		}
		return;
	}

	var text = document.form_script.script.value;
	text += "#!/bin/sh\n"+
			"# Description:\n"+
			"# This is a new application template.\n"+
			"\n"+
			"# Cycle (in us):\n"+
			"CYCLE=1000000\n"+
			"\n"+
			"# Declaration:\n"+
			"\n"+
			"# Initialization - runs one time:\n"+
			"\n"+
			"# Body - runs cyclic:\n"+
			"while true; do\n"+
			"# ... code\n"+
			"usleep $CYCLE\n"+
			"done\n"+
			"";

	document.form_script.script.value = text;
}
// ********************************************************************************************

// Text-Bestandteile des Scripts aendern
function changeScriptText (start, end, change)
{

	// Script einlesen
	var script = document.form_script.script.value;


	// Part1
	var pos_beginPart1 = 0;
	var pos_endPart1 = script.indexOf(start);
	if (pos_endPart1 == -1)
		return;
	pos_endPart1 += start.length;
	var part1 = script.slice(0, pos_endPart1);


	// Part2	
	var part2 = script.substring(pos_endPart1);
	var pos_beginPart2 = part2.indexOf(end);
	if (pos_beginPart2 == -1)
		return;
	part2 = script.slice(pos_endPart1 + pos_beginPart2);

	// Zusammenstellung
	script = part1 + change + part2;

	// TestAusgabe
	/*
	alert ("1: "+pos_beginPart1+"\n2: "+pos_endPart1+"\n3: "+part1);
	alert ("1: "+pos_beginPart2+"\n2: "+part2);
	alert ("1: "+part1+"\n2: "+change+"\n3: "+part2);
	alert (script);
	*/

	// Neues Script ausgeben	
	document.form_script.script.value = script;
}

// ********************************************************************************************

// Leerzeichen aus einem String entfernen
function deleteWhitespace (text)
{
	var text_array = text.split(" ");
	text = text_array.join("");
	return (text);
}

// ********************************************************************************************

// nur Gross-Buchstaben in einem String belassen, Rest entfernen
function cleanText (text)
{
	var newText = "";
	for (var i=0; i<text.length; i++)
	{
		if (("A" < (text.charAt(i)) && (text.charAt(i) < "Z")) || ("0" < (text.charAt(i)) && (text.charAt(i) < "9")))
			newText+=text[i];	 
	}
	return newText;
}

// ********************************************************************************************

// Alle Zeichen bis zur ersten Klammer in einem String belassen, Rest entfernen
function finishText (text)
{
	var newText = text.split("(");		// bis zur ersten Klammer
	newText = newText[0].split("/");	// wenn vorher "/", dann nur bis dahin uebernehmen
	return newText[0];
}

// ********************************************************************************************

// Namen auf Korrektheit pruefen (nur a-z, A-Z, 0-9, _)
function checkSyntax(name)
{
	// nur die Zeichen, welche auftreten drfen, g = im gesamten String
	var re = /[^a-zA-Z0-9_]/g;		

	var arr = re.test(name);	
	re.lastIndex = 0;		// fuer naechste Suche von vorn
		
	if (arr == true)	
	{	
		// Name nicht korrekt
		// alert (name+"   false");	
		return false;		// Name nicht korrekt
	}

	// Name korrekt
	// alert (name+"   true");	
	return true;			// Name korrekt
}

// ********************************************************************************************
// Buttonbeschriftung fuer Mehrsprachigkeit
function initButtons ()
{
	document.form_activateConfigButton.activate.value = unescape(ins("app_config"));
}

// ********************************************************************************************

// Auswertung Antwort:
// Bei Fehler Ausgabe in entsprechenden Messageboxen
// return: 	0 = OK
//			1 = Fehler

function getErrorMsg (content)
{

	// kein JSON, also Fehlermeldung
	if (content.indexOf("{") == -1)
	{
		// Wenn login-timeout abgelaufen ist, dann Fehlermeldung und Abbruch
		if (content.indexOf("LOGIN ERROR") != -1)	
		{
			top.messageBox (ins("main_mb_errMsg"), ins("main_mb_errLogin")); 
		}
		else
		{
			// kein JSON, Ausgabe Fehlermeldung vom EWIO in MessageBox
			top.messageBox (ins("main_mb_errMsg"), top.getMessage (content));
		}
		return(1);
	}

//	alert ("content: "+content);

	return(0);
}

// ********************************************************************************************
// ********************************************************************************************

// tree aktualisieren
function treeRefresh()
{
	// runMode ermitteln
	if (document.form_startstop.r0[0].checked == true)
		var runMode = 1;
	else
		var runMode = 0;

	// Icon im tree fuer die laufende Applikation modifizieren
	var newTreeObj = top.frame_tree.treeDataObj;
	var page = top.tree_getPageName(); 	

	for (var i=0; i<newTreeObj.applications.consisting.length; i++)
	{
		if (newTreeObj.applications.consisting[i].text == page[0])
		{
			if (runMode == 1)
				newTreeObj.applications.consisting[i].icon = "gear_green.gif";
			else
				newTreeObj.applications.consisting[i].icon = "gear_red.gif";
		}
	}

	// neue Applikation anfuegen
	var match = 1;
	for (var i=0; i<newTreeObj.applications.consisting.length; i++)
	{
		var name = top.frame_content.document.form_newName.appName.value;
		if (newTreeObj.applications.consisting[i].text == name)
		{
			match = 0;
			break;
		}	
	}
	if (match == 1)
	{
		var length = newTreeObj.applications.consisting.length;
		newTreeObj.applications.consisting[length] = new Object();
		if (document.form_startstop.r0[0].checked == true)
			newTreeObj.applications.consisting[length].icon = "gear_green.gif"; 
		else
			newTreeObj.applications.consisting[length].icon = "gear_red.gif"; 
		newTreeObj.applications.consisting[length].text = name;
		newTreeObj.applications.consisting[length].target = "application.htm";
	}	

	// geloeschte Applikationen entfernen
	if (document.form_kill.kill.checked == true)
		var kill = 1;
	else
		var kill = 0;
	for (var i=0; i<newTreeObj.applications.consisting.length; i++)
	{
		if (newTreeObj.applications.consisting[i].text == page[0])
		{
			if (kill == 1)
			{
				// Eintrag in applications.consisting entfernen					
				newTreeObj.applications.consisting.splice(i, 1);					
			}
		}
	}

	// wenn kein Eintrag mehr im Segment vorhanden ist, dann einen dummy-Eintrag erzeugen
	if (newTreeObj.applications.consisting.length == 0)	
	{
		newTreeObj.applications.consisting[0] = new Object();
		newTreeObj.applications.consisting[0].icon = "page.gif"; 
		newTreeObj.applications.consisting[0].text = "no entry";
		newTreeObj.applications.consisting[0].target = "";
	}

	oStr = JSON2.stringify (newTreeObj, null, 4);	// Object -> String

	// neuen tree zum EWIO senden
	top.frame_tree.shadeTree (1);
	setTimeout ("top.setDataExtended ('/config/www/tree/treeData.js', 'fileload', oStr)", 1000);

	// Navigation refresh
	setTimeout ("top.frame_tree.tree_getData_application(oStr)", 1000);

}

// ********************************************************************************************
// ********************************************************************************************



