/**********************************************************************************************
	JS functions for output_data_download

	Copyright (c) 2012 MCQ Tech GmbH (rstiawa@metz-connect.com)
	Version 0.1		01.2012

***********************************************************************************************/


/*
	Anmerkungen:

*/

// ********************************************************************************************



// ********************************************************************************************
// Kalender darstellen
function calendar (form, control)
{
	// whole calendar template can be redefined per individual calendar
	var A_CALTPL = {
//		'months' : ['Januar', 'Februar', 'Maerz', 'April', 'Mai', 'Juni', 'Juli', 'August', 'September', 'Oktober', 'November', 'Dezember'],
//		'weekdays' : ['So', 'Mo', 'Di', 'Mi', 'Do', 'Fr', 'Sa'],
		'months': ins("calendar_month"),		// Monate		
		'weekdays': ins("calendar_days"),		// Wochentage
		'yearscroll': true,		// show year scroller
		'weekstart': 1,			// first day of week: 0-Su or 1-Mo
		'centyear'  : 70,		// 2 digit years less than 'centyear' are in 20xx, othewise in 19xx.
		'imgpath' : 'calendar/img/'		// directory with calendar images
	}

	var name = {'formname': form, 'controlname': control};
	var o_cal = new tcal (name, A_CALTPL);
}

// ********************************************************************************************
// ********************************************************************************************
// aktuelle Zeit setzen
function getCurrentDate (element)
{
	var datum = new Date();
	
	var year = setLeadNull (datum.getFullYear()-0);		// Jahreszahl 4stellig
	var month = setLeadNull (datum.getMonth()+1);		// getMonth() von 0 ... 11
	var date = setLeadNull (datum.getDate()-0);			// Tag 1 ... 31
	
	var str = date + "." + month + "." + year; 
	element.value = str;
}

function getCurrentTime (element)
{
	var datum = new Date();
	
	var hours = setLeadNull (datum.getHours()-0);		// Stunden
	var minutes = setLeadNull (datum.getMinutes()-0);	// Minuten
	
	var str = hours + ":" + minutes; 
	element.value = str;
}

// ********************************************************************************************
// Eingaben pruefen
function cal_inputCheck(target)
{
	var err = 0;
	if (target == "to")
	{
		err = checkDateInput (document.form_dataTo.date);			// check Datum
		if (!err)
			err = checkTimeInput (document.form_dataTo.time);		// check Zeit
	}
	
	if (target == "from")
	{
		err = checkDateInput (document.form_dataFrom.date);			// check Datum
		if (!err)
			err = checkTimeInput (document.form_dataFrom.time);		// check Zeit
	}

	if (err)
	{
		// "Hinweis", "Zeiteingabe fehlerhaft: " 	
		top.messageBox (ins("calendar_note_head"), ins("calendar_error_input") + err);	
	}

	// alert ("Ergebnis:  err="+err+ "    target="+target);

	if (err)
		return 1;
	return 0;
}

// ********************************************************************************************
// ********************************************************************************************
// Datumseingabe pruefen
function checkDateInput (element)
{
	var err = 0;
	var ret = 0;
	var dateArr = element.value.split(".");
	if (dateArr.length != 3)
		err = ins("calendar_error_incomplete_date");	// "Datum unvollstaendig"
	else 
	{
		// Laengen
		if (dateArr[0].length != 2)		err = ins("calendar_error_digits_day");		// "Anzahl Ziffern / Tag"	
		if (dateArr[1].length != 2)		err = ins("calendar_error_digits_month");	// "Anzahl Ziffern / Monat"
		if (dateArr[2].length != 4)		err = ins("calendar_error_digits_year");	// "Anzahl Ziffern / Jahr"
	}			
	
	if (!err)
	{	
		// Inhalt
		ret = checkTimeComponents (dateArr[0], "day");		if (ret) err = ret;
		ret = checkTimeComponents (dateArr[1], "month");	if (ret) err = ret;
		ret = checkTimeComponents (dateArr[2], "year");		if (ret) err = ret;
	}
	
	return err;
}

// ********************************************************************************************
// Zeiteingabe pruefen
function checkTimeInput (element)
{
	var err = 0;
	var ret = 0;
	var timeArr = element.value.split(":");
	if (timeArr.length != 2)
		err = ins("calendar_error_incomplete_time");	// "Zeit unvollstaendig"
	else 
	{
		// Laengen
		if (timeArr[0].length != 2)		err = ins("calendar_error_digits_hour");	// "Anzahl Ziffern / Stunde"
		if (timeArr[1].length != 2)		err = ins("calendar_error_digits_minute");	// "Anzahl Ziffern / Minute"
	}			
	
	if (!err)
	{	
		// Inhalt
		ret = checkTimeComponents (timeArr[0], "hours");	if (ret) err = ret;
		ret = checkTimeComponents (timeArr[1], "minutes");	if (ret) err = ret;
	}

	return err;
}

// ********************************************************************************************
// Zeitkomponenten ueberpruefen
function checkTimeComponents (timeComp, check)
{
	var err = 0;
	switch (check)
	{
		case "year":	if ((isFinite (timeComp) == false) || (timeComp-0 < 1900) || (timeComp-0 > 2100))
							err = ins("calendar_error_year");	// "Jahr" 
						break;
		case "month":	if ((isFinite (timeComp) == false) || (timeComp-0 < 1) || (timeComp-0 > 12))
							err = ins("calendar_error_month");	// "Monat" 
						break;
		case "day":		if ((isFinite (timeComp) == false) || (timeComp-0 < 1) || (timeComp-0 > 31))
							err = ins("calendar_error_day");	// "Tag" 
						break;
		case "hours":	if ((isFinite (timeComp) == false) || (timeComp-0 < 0) || (timeComp-0 > 24))
							err = ins("calendar_error_hour");	// "Stunde" 
						break;
		case "minutes":	if ((isFinite (timeComp) == false) || (timeComp-0 < 0) || (timeComp-0 > 60))
							err = ins("calendar_error_minute");	// "Minute" 
						break;
		case "seconds":	if ((isFinite (timeComp) == false) || (timeComp-0 < 0) || (timeComp-0 > 60))
							err = ins("calendar_error_second");	// "Sekunde" 
						break;
	}
	return err;
}

// ********************************************************************************************
// Fuehrende Null setzen (bei zweistelligem Wert, z.B. min, sec etc.)
function setLeadNull (value)
{
	value = (value < 10) ? "0"+value : value;
	return (value);
}

// ********************************************************************************************
// ********************************************************************************************
// Eingaben konvertieren
function cal_inputConvert(target)
{
	var date_db;
	if (target == "from")
		date_db = convertDateToDB (document.form_dataFrom.date, document.form_dataFrom.time);
	if (target == "to")
		date_db = convertDateToDB (document.form_dataTo.date, document.form_dataTo.time);

	// alert (date_db);	
	return date_db;
}

// ********************************************************************************************
// DE-Datum in DB-Format convertieren (yyyy-mm-dd hh:mm:ss)
function convertDateToDB (elementDate, elementTime)
{
	var dateArr = elementDate.value.split(".");
	var timeArr = elementTime.value.split(":");
	date = dateArr[2]+'-'+dateArr[1]+'-'+dateArr[0]+'|'+timeArr[0]+':'+timeArr[1]+':00';
	return date;
}

// ********************************************************************************************
// ********************************************************************************************








		
		
		
