#!/bin/sh

# Test mit curl
# -v 					// mit Ausschriften
# -k 					// ohne Vergleich, ob das Zertifikat oeffentlich bekannt ist
# --silent				// keine Ausgaben
# --connect-timeout  	// Timeout bei Verbindungsaufbau in sec
# --write-out			// Ausgabe nach Beendigung von curl, %{http_code} = Letzter empfangener HTTP/FTP-Code

#./curl --version

# Datei sqlite3 vom EWIO nach PC in das Verzeichnis <FTP-Server>/data/more_data als Datei test.txt
#./curl -v -k -T sqlite3 --ftp-ssl --ftp-pasv -u root:ewio ftp://10.22.0.51/more_data/test.txt

# Datei /config/etc/counter.conf vom EWIO nach PC in das Verzeichnis <FTP-Server>/data/more_data als Datei counter.txt
#./curl -v -T /config/etc/counter.conf --ftp-ssl --ftp-pasv -u root:ewio ftp://10.22.0.51/more_data/counter.txt

# Test mit ftpput
#ftpput -v -u root -p ewio -P 21 10.22.0.51 testput.txt sqlite3

# curl mit SSL, ohne EPSV
#./curl -v  -k --cacert /config/etc/stunnel/stunnel.pem --disable-epsv --ftp-skip-pasv-ip -T /config/usr/bin/vsftpd --ftp-ssl --ftp-pasv -u root:ewio #ftp://10.22.0.51/vsftpd

# curl mit SSL
#./curl -v -k --cacert /config/etc/stunnel/stunnel.pem -T /config/usr/bin/vsftpd --ftp-ssl --ftp-pasv -u root:ewio ftp://10.22.0.51/vsftpd --connect-timeout 10

# curl ohne SSL
#./curl -v -T /config/etc/counter.conf -u root:ewio sftp://10.22.0.54/counter.txt


# stdout auf Konsole, stderr nach /var/log/ftp1(2)
# result = 226 OK (successfully transferred), alles andere Fehler
result=$(./curl -v -k --cacert /config/etc/stunnel/stunnel.pem -T /config/usr/bin/vsftpd --ftp-ssl --ftp-pasv -u root:ewio ftp://10.22.0.51/vsftpd --connect-timeout 3 --write-out "%{http_code}" 2> /var/log/ftp1) 
echo result=$result
 

