#!/bin/sh
# search wlan

INTERFACE="wlan0"
output_file="/config/etc/network/wlan_list.txt"

# scan durchfuehren
scanlist=`/sbin/iwlist $INTERFACE scan`
#echo scanlist=$scanlist

# wlan-Parameter aus scan-list entnehmen
essid_list=`echo "$scanlist" | /bin/sed -n -e 's/ESSID:"\(.*\)"/\1 |/p'`
#quality_list=`echo "$scanlist" | /bin/sed -n -e 's/Quality=\(.\{5\}\).*/\1 |/p'`
quality_list=`echo "$scanlist" | /bin/sed -n -e 's/Quality[=:]\([0-9]\{1,3\}\).*/\1 |/p'`
siglevel_list=`echo "$scanlist" | /bin/sed -n -e 's/.*Signal level=\(.*\)/\1 |/p'`
mode_list=`echo "$scanlist" | /bin/sed -n -e 's/Mode:\(.*\)/\1 |/p'`

# Ergebnisse in Datei schieben
echo "ssid: "$essid_list > $output_file
echo "quality: "$quality_list >> $output_file
echo "siglevel: "$siglevel_list >> $output_file
echo "mode: "$mode_list >> $output_file


# einige Netzwerke geben keine Verschluesselung an, andere mehrere;
# daher wird jeweils zwischen 2 Zellen gesucht, ob eine WPA- oder WEP-Angabe vorhanden ist;
# Wenn der Schleifenindex die Anzahl der vorhandenen Zellen erreicht hat, Abbruch (Maximal 30) 
counter=`echo "$essid_list" | /bin/sed -n '$='`
echo cnt=$counter

codelist="coding: "
for i in 0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32 33 34 35; do
	x=`expr $i + 1`
	if [ $x -lt 10 ]; then 
	  x=0$x
	fi
	
	y=`expr $i + 2`
	if [ $y -lt 10 ]; then 
	  y=0$y
	fi	
	
	code_list_1=`echo "$scanlist" | /bin/sed -n -e '/Cell '$x'/,/Cell '$y'/s/IE.*\(WPA.\).*/\1/p'`
	code_list_2=`echo "$scanlist" | /bin/sed -n -e '/Cell '$x'/,/Cell '$y'/s/IE.*\(WEP\).*/\1/p'`
	
	# echo code_list $x = $code_list_1 $code_list_2
	codelist=${codelist}${code_list_1}${code_list_2}" |" 

	if [ $x == $counter ]; then
		break
	fi
done

# Ergebnisse in Datei schieben
echo $codelist >> $output_file







