#!/bin/sh
# Pruefen, ob mbus_controller noch funktionstuechtig ist

# Funktion: Kommunikation pruefen
check()
{
	ps | grep mbus_controller | grep -qv grep 
	# $? = 0 -> mbus_controller laeuft
	# $? = 1 -> laeuft nicht
	return $?
}


# Programm wird vor der Abfrage der Zaehler gestartet 
# 0 - OK
# 1 - Fehler		1. mbus_controller neu starten
#					2. reboot

# echo "check mbus_controller"
check
if [ $? -eq 1 ];then
	echo "mbus_check: mbus_controller wird neu gestartet"
	# Fehlermeldung in mbusLog (LEVEL_USER)
	/config/bin/counter/counter_setMbusLog mbus_check 0 1 "MBUS: mbus_controller restart"
	killall -q mbus_controller		
	/config/bin/mbus/mbus_controller &	
	sleep 30

	check
	if [ $? -eq 1 ];then
		echo "mbus_check: reboot EWIO-M"
		# Fehlermeldung in mbusLog (LEVEL_USER)
		/config/bin/counter/counter_setMbusLog mbus_check 0 1 "MBUS: EWIO-M reboot"
		reboot
	fi	
fi
	 

