#!/bin/sh
# Description:
# Treiber mit aktueller Konfiguration starten

driverName=$1
json_path="/config/configbase"
driver_path="/sys/bus/platform/drivers"
err="jsonc-error"
bacnet_server_flag=0
modbus_server_flag=0

# Wenn nicht der Bacnet-Server dies Skript startet, muss er, falls er läuft,
# gestoppt und später wieder gestartet werden. Beim Zugriff auf einen
# nicht vorhandenen Kernel-Treiber kann es sonst eine Kernel-Panic geben.
if [ "$2" != "bacnet-server" ]; then
#     echo "Aufruf von driver_start.sh nicht aus Bacnet-Server"
    if [ `pgrep bacnet-server` ]; then
        echo "Bacnet-Server stop"
        pkill bacnet-server
        sleep 1
        bacnet_server_flag=1
    fi
# else
#     echo "Aufruf von driver_start.sh aus Bacnet-Server"
fi

# Wenn nicht der Modbus-Server dies Skript startet, muss er, falls er läuft,
# gestoppt und später wieder gestartet werden. Beim Zugriff auf einen
# nicht vorhandenen Kernel-Treiber kann es sonst eine Kernel-Panic geben.
if [ -n "`pgrep modbus-gateway`" ]; then
    echo "Modbus-Gateway stop"
    killall modbus-gateway
    sleep 1
    modbus_server_flag=1
fi


# pruefen, ob Treiber laeuft; wenn ja, beenden
driver=`lsmod`
if echo "$driver" | grep -q $driverName
then
    # Treiber stoppen
    echo 0 > $driver_path/$driverName/command
    # Treiber abmelden
    modprobe -r $driverName
    echo $driverName killed
fi

# JSON lesen, JSON string darf keine Leerzeichen, Umbrueche etc enthalten
content=`/config/bin/json/jsonc_printCompact $json_path/$driverName.json`

# Treiber neu im System registrieren
if [ "$content" = "$err" ]; then
    modprobe $driverName command=1
else
    modprobe $driverName json="\"$content\""
fi
echo $driverName started


# Wenn der Bacnet-Server vorhin gestoppt wurde, wird er wieder gestartet.
# Er muss ein Hintergrundprozess werden, damit dieses Skript enden kann.
if [ $bacnet_server_flag = 1 ]; then
    echo "Bacnet-Server start"
    /config/bin/bacnet_server_start.sh &
fi

# Wenn der Modbus-Server vorhin gestoppt wurde, wird er wieder gestartet.
# Er muss ein Hintergrundprozess werden, damit dieses Skript enden kann.
if [ $modbus_server_flag = 1 ]; then
    echo "Modbus-Gateway start"
    /config/bin/modbus_gateway_start.sh &
fi

