#!/bin/sh
# Alle Treiber mit aktueller Konfiguration neu starten

bacnet_server_flag=0
modbus_server_flag=0

# Wenn nicht der Bacnet-Server dies Skript startet, muss er, falls er läuft,
# gestoppt und später wieder gestartet werden. Beim Zugriff auf einen
# nicht vorhandenen Kernel-Treiber kann es sonst eine Kernel-Panic geben.
if [ "$2" != "bacnet-server" ]; then
#     echo "Aufruf von driver_restart_all.sh nicht aus Bacnet-Server"
    if [ `pgrep bacnet-server` ]; then
        echo "Bacnet-Server stop"
        pkill bacnet-server
        sleep 1
        bacnet_server_flag=1
    fi
# else
#     echo "Aufruf von driver_restart_all.sh aus Bacnet-Server"
fi

# Wenn nicht der Modbus-Server dies Skript startet, muss er, falls er läuft,
# gestoppt und später wieder gestartet werden. Beim Zugriff auf einen
# nicht vorhandenen Kernel-Treiber kann es sonst eine Kernel-Panic geben.
if [ -n "`pgrep modbus-gateway`" ]; then
    echo "Modbus-Gateway stop"
    killall modbus-gateway
    sleep 1
    modbus_server_flag=1
fi


# Alle Kernel-Treiber neu starten
/config/bin/driver_start.sh mct_spi_dio $2
/config/bin/driver_start.sh mct_spi_aio $2
/config/bin/driver_start.sh mct_pin_di_0 $2
/config/bin/driver_start.sh mct_pin_di_1 $2
/config/bin/driver_start.sh mct_pin_di_2 $2
/config/bin/driver_start.sh mct_pin_di_3 $2
/config/bin/extDriver_start.sh "" $2


# Wenn der Bacnet-Server vorhin gestoppt wurde, wird er wieder gestartet.
# Er muss ein Hintergrundprozess werden, damit dieses Skript enden kann.
if [ $bacnet_server_flag = 1 ]; then
    echo "Bacnet-Server start"
    /config/bin/bacnet_server_start.sh &
fi

# Wenn der Modbus-Server vorhin gestoppt wurde, wird er wieder gestartet.
# Er muss ein Hintergrundprozess werden, damit dieses Skript enden kann.
if [ $modbus_server_flag = 1 ]; then
    echo "Modbus-Gateway start"
    /config/bin/modbus_gateway_start.sh &
fi

