#!/bin/sh

# Description:

# Ausgeloest durch counter_trigger / counter_wrapper startet der scheduler nacheianander 
# den counter_controller mit der jeweiligen mbus-id und dem uebergebenen timestamp.
# Die Reihenfolge wird durch die vorkonfigurierte Sortierung bestimmt.

# Aufruf:	./counter_scheduler.sh source timestamp mode &

# source = timer	Timer is trigger source
# source = sync		SyncPuls is trigger source

# timestamp 		timestamp, form = wddmmyyyyHHMM

# mode = all		average + counter_scheduler	
# mode = average	average only
# mode = scheduler	counter_scheduler only 

# -------------------------------------------------------------------
#Debug-Ausgaben
DEBUG=1

# -------------------------------------------------------------------
# Uebergabeparameter
source=$1
timestamp=$2
mode=$3

# -------------------------------------------------------------------
# FREEZE
if [ "$mode" == "scheduler" ] || [ "$mode" == "all" ];then
	# FREEZE senden (MBus und interne S0/M_Converter)
	/config/bin/mbus/mbus_test /dev/ttyS2 0 9600 0 FREEZE_DATA 0
	/config/bin/mbus/mbus_test /dev/ttyS2 0 2400 0 FREEZE_DATA 0
	/config/bin/mbus/mbus_test /dev/ttyS2 0 300 0 FREEZE_DATA 0
	/config/bin/mbus/mbus_test /sys/bus/platform/devices/mct_if.01.2-0-0.0/mbus 0 9600 0 FREEZE_DATA 0
	/config/bin/mbus/mbus_test /sys/bus/platform/devices/mct_if.01.2-0-1.0/mbus 0 9600 0 FREEZE_DATA 0
	/config/bin/mbus/mbus_test /sys/bus/platform/devices/mct_if.01.2-0-2.0/mbus 0 9600 0 FREEZE_DATA 0
	/config/bin/mbus/mbus_test /sys/bus/platform/devices/mct_if.01.2-0-3.0/mbus 0 9600 0 FREEZE_DATA 0
	sleep 1
fi

# -------------------------------------------------------------------
# average (Mittelwertbildung)

if [ "$mode" == "average" ] || [ "$mode" == "all" ];then
	# Jede Minute Datenpunkte ermitteln und Werte speichern (15s/80 Zaehler)
	if [ $DEBUG -eq 1 ];then
		echo -n "counter_getAverage ... "
	fi
	/config/bin/counter/counter_getAverage
	if [ $DEBUG -eq 1 ];then
		echo "OK"
	fi
fi

if [ "$mode" == "average" ];then
	exit 0;
fi

# -------------------------------------------------------------------

if [ $DEBUG -eq 1 ];then
	echo "counter_scheduler: start" 
fi

# Datenabfrage
mbus_id=0
while true; do
	# mbus-id entsprechend Position aus DB ermitteln
	mbus_id=$(/config/bin/counter/counter_getAddress $mbus_id)
	
	if [ "$mbus_id" == "error, get address" ];then
		if [ $DEBUG -eq 1 ];then
			echo "counter_scheduler: end, $mbus_id address error" 
		fi
		# Meldung in mbusLog (LEVEL_USER)
		/config/bin/counter/counter_setMbusLog counter_scheduler 0 1 "COUNTER: end, $mbus_id address error"
		exit 1	
	fi
	if [ "$mbus_id" == "error, db busy" ];then
		if [ $DEBUG -eq 1 ];then
			echo "counter_scheduler: getAddress, $mbus_id DB busy" 
		fi
		# Meldung in mbusLog (LEVEL_USER)
		/config/bin/counter/counter_setMbusLog counter_scheduler 0 1 "COUNTER: getAddress, $mbus_id DB busy"
		continue
	fi
	if [ "$mbus_id" == "no more counter" ];then
		if [ $DEBUG -eq 1 ];then
			echo "counter_scheduler: end, no more counter" 
		fi
		# Messwertdateien zusammenstellen nach Abschluss der Messwerterfassung
		/config/bin/db/db_configOutput $timestamp
		ret=$?	
		if [ $ret -eq 0 ];then
			result="- FILES CREATED"
		elif [ $ret -eq 1 ];then
			result="- NO PUSH/POLL REQUEST"
		elif [ $ret -eq 2 ];then
			result="- NO GRID MATCH"
		elif [ $ret -eq 3 ];then
			result="- NO INTERVAL MATCH"
		fi
		if [ $DEBUG -eq 1 ];then
			echo "output from DB" $result
		fi
		exit 0	
	fi

	# Daten abrufen und speichern (max. 2 Versuche durch counter_controller))
	/config/bin/counter/counter_controller $mbus_id $timestamp $1 
	ret=$?	

	# noch weiter versuchen, falls DB busy
	while [ $ret -eq 3 ]; do
		sleep 1
		/config/bin/counter/counter_controller $mbus_id $timestamp $source 
		ret=$?	
	done

	if [ $ret -eq 0 ];then
		result="- SAVED"
	elif [ $ret -eq 1 ];then
		result="- ERROR"
		# Meldung in mbusLog (LEVEL_USER)
		/config/bin/counter/counter_setMbusLog counter_scheduler 0 1 "COUNTER: $mbus_id $timestamp $1 $result"
	elif [ $ret -eq 2 ];then
		result="- NO INTERVAL"
	elif [ $ret -eq 3 ];then
		result="- NO STORE, DB BUSY"
	fi
	if [ $DEBUG -eq 1 ];then
		echo "call counter_controller" $mbus_id $timestamp $result
	fi

	# Meldung in mbusLogDev (LEVEL_DEVELOPER)
	/config/bin/counter/counter_setMbusLog counter_scheduler 0 2 "COUNTER: $mbus_id $timestamp $1 $result"

	# Meldung, wenn DB busy
	if [ $ret -eq 3 ];then
		if [ $DEBUG -eq 1 ];then
			echo "counter_scheduler: $mbus_id DB busy" 
		fi
		# Meldung in mbusLog (LEVEL_USER)
		/config/bin/counter/counter_setMbusLog counter_scheduler 0 1 "COUNTER: $mbus_id DB busy"
	fi
done


